## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----include=FALSE------------------------------------------------------------
knitr::opts_chunk$set(eval = TRUE)

## ----setup--------------------------------------------------------------------
library(GINAX)

## -----------------------------------------------------------------------------
data("Y_poisson")
Y_poisson[1:5]

## -----------------------------------------------------------------------------
data("Y_binary")
Y_binary[1:5]

## -----------------------------------------------------------------------------
data("SNPs")
SNPs[1:5,1:5]

## -----------------------------------------------------------------------------
data("kinship")
kinship[1:5,1:5]

## -----------------------------------------------------------------------------
n <- length(Y_poisson)
covariance <- list()
covariance[[1]] <- kinship
covariance[[2]] <- diag(1, nrow = n, ncol = n)

## ----long-example1, eval = FALSE----------------------------------------------
# # This example is computationally intensive and is shown but not evaluated in this vignette.
# # You can run it manually in your R session.
# output_poisson <- GINAX(Y=Y_poisson, Covariance=covariance, SNPs=SNPs, family="poisson", Z=NULL, offset=log(15),FDR_Nominal = 0.05, maxiterations = 1000, runs_til_stop = 200)
# output_poisson

## -----------------------------------------------------------------------------
covariance <- list()
covariance[[1]] <- kinship

## ----long-example2, eval = FALSE----------------------------------------------
# # This example is computationally intensive and is shown but not evaluated in this vignette.
# # You can run it manually in your R session.
# output_binary <- GINAX(Y=Y_binary, Covariance=covariance, SNPs = SNPs, family = "bernoulli", Z=NULL, offset=NULL, FDR_Nominal = 0.05, maxiterations = 2000, runs_til_stop = 400)
# output_binary

