## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  out.width = '100%',
  fig.width = 6,
  fig.height = 4,
  comment = "#>"
)

## ----setup, echo=FALSE, results='hide', message=FALSE, warning=FALSE, error=FALSE----
library(brickset)
library(ggplot2)
library(dplyr)
theme_set(theme_minimal())

## -----------------------------------------------------------------------------
data(legosets)
last_year <- max(legosets$year)
legosets <- legosets |> 
	dplyr::select(year, US_retailPrice, pieces, minifigs, themeGroup) |>
	dplyr::filter(year %in% seq(last_year - 10, last_year)) |>
	na.omit()

## -----------------------------------------------------------------------------
lego_model <- US_retailPrice ~ pieces + minifigs

## ----warning=FALSE------------------------------------------------------------
ggplot(legosets, aes(x = pieces, y = US_retailPrice, size = minifigs, color = themeGroup)) +
	geom_point(alpha = 0.2)

## -----------------------------------------------------------------------------
table(legosets$themeGroup, useNA = 'ifany')

## -----------------------------------------------------------------------------
legosets$themeGroup <- as.factor(legosets$themeGroup)
legosets$themeGroup <- relevel(legosets$themeGroup, ref = 'Licensed')

## -----------------------------------------------------------------------------
lm_out <- lm(US_retailPrice ~ pieces + minifigs + themeGroup, data = legosets)
summary(lm_out)

## -----------------------------------------------------------------------------
legosets$predicted <- predict(lm_out)
legosets$residuals <- resid(lm_out)
ggplot(legosets, aes(x = residuals)) + geom_histogram(binwidth = 10)

