/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.sa.base.core.tests.SeasonalityTests;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.SeasonalFTest;
import jdplus.toolkit.base.core.sarima.SarimaModel;

class SeasonalOverDifferencingTest {
    private static final double THRESHOLD = -0.7;
    private static final double SIGNIF = 0.01;

    SeasonalOverDifferencingTest() {
    }

    public int test(RegSarimaModelling context) {
        boolean fsign;
        SarimaModel arima = context.getDescription().arima();
        SarimaOrders spec = arima.orders();
        if (spec.getPeriod() == 1) {
            return 0;
        }
        if (spec.getBp() == 1 || spec.getBd() == 0 || spec.getBq() == 0 || arima.btheta(1) >= -0.7) {
            return 0;
        }
        DoubleSeq lin = context.getEstimation().linearizedSeries();
        SeasonalityTests tests = SeasonalityTests.seasonalityTest((DoubleSeq)lin, (int)spec.getPeriod(), (int)1, (boolean)true, (boolean)true);
        SeasonalFTest ftest = new SeasonalFTest();
        ftest.test(context.getDescription());
        int score = tests.getScore();
        boolean bl = fsign = ftest.getFTest().getPvalue() < 0.01;
        if (fsign) {
            ++score;
        }
        if (score >= 2 || fsign || tests.getQs().getPvalue() < 0.01) {
            return 1;
        }
        return 2;
    }
}

