/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.x13.base.core.x13.X13Results;
import jdplus.x13.base.core.x13.diagnostics.MDiagnostics;
import jdplus.x13.base.core.x13.diagnostics.MDiagnosticsConfiguration;

public class MDiagnosticsFactory
implements SaDiagnosticsFactory<MDiagnosticsConfiguration, X13Results> {
    public static final String NAME = "M-Statistics";
    public static final String Q = "q";
    public static final String Q2 = "q2";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("q", "q2"));
    private final MDiagnosticsConfiguration config;

    public MDiagnosticsFactory(MDiagnosticsConfiguration config) {
        this.config = config;
    }

    public MDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public MDiagnosticsFactory with(MDiagnosticsConfiguration config) {
        return new MDiagnosticsFactory(config);
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(X13Results rslts) {
        return MDiagnostics.of(this.config, rslts);
    }

    public SaDiagnosticsFactory.Scope getScope() {
        return SaDiagnosticsFactory.Scope.Decomposition;
    }

    public int getOrder() {
        return 100;
    }
}

