## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.path = "man/figures/vignette_",
  out.width = "100%"
)

## ----setup--------------------------------------------------------------------
library(setweaver)

## ----example_1, results='hide',message=FALSE----------------------------------
# Loading the package, which automatically also downloads the example data (misimdata)
library(setweaver) 

# Pairing variables
results = pairmi(misimdata[,2:11],alpha = 0.05,n_elements = 5)

## ----table_1,echo=FALSE,results='asis'----------------------------------------
knitr::kable(results$expanded.data[c(1:5),],caption = 'Table 1. Expanded Data',align = c('c'))

## ----table_2,echo=FALSE,results='asis'----------------------------------------
knitr::kable(results$sets,caption = 'Table 2. Information on sets',align = c('c'))

## ----example_2, results='hide',message=FALSE----------------------------------
# Evaluating the sets
evaluated_sets = probstat(misimdata$y,results$expanded.data[,results$sets$set],nfolds = 5)

## ----table_3,echo=FALSE,results='asis'----------------------------------------
knitr::kable(evaluated_sets[c(1:5),],caption = 'Table 3. Evaluated sets',align = c('c'))

## ----example_3, fig.align = "center", fig.height = 6, fig.width =8, fig.cap="Plot 1. Setmap of sets that consist of 2 elements"----
# Visualizing the sets
setmapmi(results$original.variables,results$sets,n_elements = 2)

## ----example_4, fig.align = "center", fig.height = 6, fig.width = 6, fig.cap="Plot 2. Graph showing the relation between certain sets and an outcome y"----
# Creating a graph where sets are relate to an outcome using logistic regression effects
plot_prob(cbind(y=misimdata[,1],results$expanded.data[,13:17]),
          'y',colnames(results$expanded.data[,13:17]),method='logistic')

## ----example_5, results='hide',message=FALSE----------------------------------
# Compute entropy and mutual information diagnostics for selected variables
descriptives = entfuns(misimdata$y,misimdata[,2:3])

## ----table_4,echo=FALSE,results='asis'----------------------------------------
knitr::kable(entfuns(misimdata$y,misimdata[,2:3]),caption = 'Table 4. Diagnostic statistics from entfuns()',align = c('c'))

