/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.map.tlong.AbstractLongLongMap;
import cern.colt.map.tlong.OpenLongLongHashMap;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.SelectedSparseLongMatrix3D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;

public class SparseLongMatrix3D
extends LongMatrix3D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongLongMap elements;

    public SparseLongMatrix3D(long[][][] lArray) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length, lArray.length == 0 ? 0 : (lArray[0].length == 0 ? 0 : lArray[0][0].length));
        this.assign(lArray);
    }

    public SparseLongMatrix3D(int n, int n2, int n3) {
        this(n, n2, n3, n * n2 * (n3 / 1000), 0.2, 0.5);
    }

    public SparseLongMatrix3D(int n, int n2, int n3, int n4, double d, double d2) {
        block2: {
            try {
                this.setUp(n, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongLongHashMap(n4, d, d2);
    }

    protected SparseLongMatrix3D(int n, int n2, int n3, AbstractLongLongMap abstractLongLongMap, int n4, int n5, int n6, int n7, int n8, int n9) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6, n7, n8, n9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongLongMap;
        this.isNoView = false;
    }

    public LongMatrix3D assign(long l) {
        if (this.isNoView && l == 0L) {
            this.elements.clear();
        } else {
            super.assign(l);
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongLongMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public synchronized long getQuick(int n, int n2, int n3) {
        return this.elements.get((long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride);
    }

    public long index(int n, int n2, int n3) {
        return (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
    }

    public LongMatrix3D like(int n, int n2, int n3) {
        return new SparseLongMatrix3D(n, n2, n3);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return new SparseLongMatrix2D(n, n2);
    }

    public synchronized void setQuick(int n, int n2, int n3, long l) {
        long l2 = (long)this.sliceZero + (long)n * (long)this.sliceStride + (long)this.rowZero + (long)n2 * (long)this.rowStride + (long)this.columnZero + (long)n3 * (long)this.columnStride;
        if (l == 0L) {
            this.elements.removeKey(l2);
        } else {
            this.elements.put(l2, l);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.slices).append(" x ").append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    long l = this.getQuick(i, j, k);
                    if (l == 0L) continue;
                    stringBuilder.append('(').append(i).append(',').append(j).append(',').append(k).append(')').append('\t').append(l).append('\n');
                }
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public LongMatrix1D vectorize() {
        SparseLongMatrix1D sparseLongMatrix1D = new SparseLongMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            sparseLongMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return sparseLongMatrix1D;
    }

    protected boolean haveSharedCellsRaw(LongMatrix3D longMatrix3D) {
        if (longMatrix3D instanceof SelectedSparseLongMatrix3D) {
            SelectedSparseLongMatrix3D selectedSparseLongMatrix3D = (SelectedSparseLongMatrix3D)longMatrix3D;
            return this.elements == selectedSparseLongMatrix3D.elements;
        }
        if (longMatrix3D instanceof SparseLongMatrix3D) {
            SparseLongMatrix3D sparseLongMatrix3D = (SparseLongMatrix3D)longMatrix3D;
            return this.elements == sparseLongMatrix3D.elements;
        }
        return false;
    }

    protected LongMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        return new SparseLongMatrix2D(n, n2, this.elements, n3, n4, n5, n6);
    }

    protected LongMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        return new SelectedSparseLongMatrix3D(this.elements, nArray, nArray2, nArray3, 0);
    }
}

