% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv.R
\name{bulk_write_csv}
\alias{bulk_write_csv}
\title{Bulk Write Comma Separated Files}
\usage{
bulk_write_csv(x, ...)
}
\arguments{
\item{x}{A list of objects to be written to \command{csv}.}

\item{...}{Arguments passed to
\code{\link{write_csv}}.}
}
\value{
The list holding the return values of \code{\link{write_csv}}.
}
\description{
Write a bunch of objects to disk using \code{\link{write_csv}}.
}
\examples{
unlink(dir(tempdir(), full.names = TRUE))
data(mtcars)
mt_german <- mtcars
rownames(mt_german)[1] <- "Mazda R\u00f64"
names(mt_german)[1] <- "mg\u00dc"
for (i in 1:10) {
    f <- file.path(tempdir(), paste0("f", i, ".csv"))
    write.csv(mtcars[1:5, TRUE], file = f)
    f <- file.path(tempdir(), paste0("f", i, "_german.csv"))
    write.csv2(mt_german[1:7, TRUE], file = f, fileEncoding = "Latin1")
}
#\% read
bulk <- bulk_read_csv(tempdir())

print(mtime <- file.info(list.files(tempdir(), full.names = TRUE))["mtime"])
bulk[["f2"]][3, 5] <- bulk[["f2"]][3, 5] + 2
Sys.sleep(2) # make sure the mtimes would change
result <- bulk_write_csv(bulk)
print(new_times <- file.info(dir(tempdir(), full.names = TRUE))["mtime"])
index_change <- grep("f2\\\\.csv", rownames(mtime))
if (requireNamespace("digest", quietly = TRUE)) {
    only_f2_changed <- all((mtime == new_times)[-c(index_change)]) &&
        (mtime < new_times)[c(index_change)]
    RUnit::checkTrue(only_f2_changed)
} else {
    RUnit::checkTrue(all(mtime < new_times))
}
}
\seealso{
Other CSV functions: 
\code{\link{bulk_read_csv}()},
\code{\link{check_ascii_file}()},
\code{\link{csv2csv}()},
\code{\link{csv}}
}
\concept{CSV functions}
