/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.graph.directed;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.delta.GraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.graph.DirectedGraphView;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class DirectedNodeInducedSubgraphView
extends DirectedGraphView<DirectedGraphVar> {
    protected DirectedGraph lb;
    protected DirectedGraph ub;
    protected DirectedGraphVar graphVar;
    protected boolean exclude;
    protected ISet nodes;

    public DirectedNodeInducedSubgraphView(String name, DirectedGraphVar graphVar, ISet nodes, boolean exclude) {
        super(name, (Variable[])new DirectedGraphVar[]{graphVar});
        this.exclude = exclude;
        this.graphVar = graphVar;
        this.nodes = nodes;
        this.lb = GraphFactory.makeNodeInducedSubgraph(this.getModel(), (DirectedGraph)graphVar.getLB(), (DirectedGraph)graphVar.getUB(), nodes, exclude);
        this.ub = GraphFactory.makeNodeInducedSubgraph(this.getModel(), (DirectedGraph)graphVar.getUB(), (DirectedGraph)graphVar.getUB(), nodes, exclude);
    }

    @Override
    public DirectedGraph getLB() {
        return this.lb;
    }

    @Override
    public DirectedGraph getUB() {
        return this.ub;
    }

    @Override
    public int getNbMaxNodes() {
        return this.graphVar.getNbMaxNodes();
    }

    @Override
    public boolean isDirected() {
        return this.graphVar.isDirected();
    }

    @Override
    protected boolean doRemoveNode(int node) throws ContradictionException {
        return this.graphVar.removeNode(node, this);
    }

    @Override
    protected boolean doEnforceNode(int node) throws ContradictionException {
        return this.graphVar.enforceNode(node, this);
    }

    @Override
    protected boolean doRemoveEdge(int from, int to) throws ContradictionException {
        return this.graphVar.removeEdge(from, to, this);
    }

    @Override
    protected boolean doEnforceEdge(int from, int to) throws ContradictionException {
        return this.graphVar.enforceEdge(from, to, this);
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if ((event.getMask() & GraphEventType.ADD_NODE.getMask()) > 0) {
            this.notifyPropagators(GraphEventType.ADD_EDGE, this);
        }
        this.notifyPropagators(event, this);
    }

    @Override
    public IGraphDeltaMonitor monitorDelta(ICause propagator) {
        return new GraphViewDeltaMonitor(new IGraphDeltaMonitor[]{this.graphVar.monitorDelta(propagator)}){

            @Override
            public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
                IntProcedure filter = i -> {
                    if (DirectedNodeInducedSubgraphView.this.exclude && !DirectedNodeInducedSubgraphView.this.nodes.contains(i)) {
                        proc.execute(i);
                    } else if (!DirectedNodeInducedSubgraphView.this.exclude && DirectedNodeInducedSubgraphView.this.nodes.contains(i)) {
                        proc.execute(i);
                    }
                };
                this.deltaMonitors[0].forEachNode(filter, evt);
            }

            @Override
            public void forEachEdge(PairProcedure proc, GraphEventType evt) throws ContradictionException {
                PairProcedure filter = (from, to) -> {
                    if (DirectedNodeInducedSubgraphView.this.exclude && !DirectedNodeInducedSubgraphView.this.nodes.contains(from) && !DirectedNodeInducedSubgraphView.this.nodes.contains(to)) {
                        proc.execute(from, to);
                    } else if (!DirectedNodeInducedSubgraphView.this.exclude && DirectedNodeInducedSubgraphView.this.nodes.contains(from) && DirectedNodeInducedSubgraphView.this.nodes.contains(to)) {
                        proc.execute(from, to);
                    }
                };
                this.deltaMonitors[0].forEachEdge(filter, evt);
            }
        };
    }
}

