/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TransformSpec
implements Validatable<TransformSpec> {
    public static final double DEF_FCT = 0.95;
    public static final boolean DEF_OUTLIERS = false;
    public static final boolean DEF_CHECK = true;
    public static final LengthOfPeriodType DEF_ADJUST = LengthOfPeriodType.None;
    @NonNull
    private final TimeSelector span;
    private final double fct;
    private final boolean preliminaryCheck;
    private final boolean outliersCorrection;
    private final TransformationType function;
    private final LengthOfPeriodType adjust;
    public static final TransformSpec DEFAULT_UNUSED = (TransformSpec)TransformSpec.builder().build();
    public static final TransformSpec DEFAULT_AUTO = (TransformSpec)TransformSpec.builder().function(TransformationType.Auto).build();

    public static Builder builder() {
        return new Builder().span(TimeSelector.all()).fct(0.95).preliminaryCheck(true).outliersCorrection(false).function(TransformationType.None).adjust(DEF_ADJUST);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_UNUSED);
    }

    public TransformSpec validate() throws IllegalArgumentException {
        return this;
    }

    @Generated
    TransformSpec(@NonNull TimeSelector span, double fct, boolean preliminaryCheck, boolean outliersCorrection, TransformationType function, LengthOfPeriodType adjust) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.span = span;
        this.fct = fct;
        this.preliminaryCheck = preliminaryCheck;
        this.outliersCorrection = outliersCorrection;
        this.function = function;
        this.adjust = adjust;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().span(this.span).fct(this.fct).preliminaryCheck(this.preliminaryCheck).outliersCorrection(this.outliersCorrection).function(this.function).adjust(this.adjust);
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public double getFct() {
        return this.fct;
    }

    @Generated
    public boolean isPreliminaryCheck() {
        return this.preliminaryCheck;
    }

    @Generated
    public boolean isOutliersCorrection() {
        return this.outliersCorrection;
    }

    @Generated
    public TransformationType getFunction() {
        return this.function;
    }

    @Generated
    public LengthOfPeriodType getAdjust() {
        return this.adjust;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformSpec)) {
            return false;
        }
        TransformSpec other = (TransformSpec)o;
        if (Double.compare(this.getFct(), other.getFct()) != 0) {
            return false;
        }
        if (this.isPreliminaryCheck() != other.isPreliminaryCheck()) {
            return false;
        }
        if (this.isOutliersCorrection() != other.isOutliersCorrection()) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        if (this$span == null ? other$span != null : !this$span.equals(other$span)) {
            return false;
        }
        TransformationType this$function = this.getFunction();
        TransformationType other$function = other.getFunction();
        if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
            return false;
        }
        LengthOfPeriodType this$adjust = this.getAdjust();
        LengthOfPeriodType other$adjust = other.getAdjust();
        return !(this$adjust == null ? other$adjust != null : !this$adjust.equals(other$adjust));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fct = Double.doubleToLongBits(this.getFct());
        result = result * 59 + (int)($fct >>> 32 ^ $fct);
        result = result * 59 + (this.isPreliminaryCheck() ? 79 : 97);
        result = result * 59 + (this.isOutliersCorrection() ? 79 : 97);
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        TransformationType $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        LengthOfPeriodType $adjust = this.getAdjust();
        result = result * 59 + ($adjust == null ? 43 : $adjust.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TransformSpec(span=" + String.valueOf(this.getSpan()) + ", fct=" + this.getFct() + ", preliminaryCheck=" + this.isPreliminaryCheck() + ", outliersCorrection=" + this.isOutliersCorrection() + ", function=" + String.valueOf(this.getFunction()) + ", adjust=" + String.valueOf(this.getAdjust()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<TransformSpec> {
        @Generated
        private TimeSelector span;
        @Generated
        private double fct;
        @Generated
        private boolean preliminaryCheck;
        @Generated
        private boolean outliersCorrection;
        @Generated
        private TransformationType function;
        @Generated
        private LengthOfPeriodType adjust;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder fct(double fct) {
            this.fct = fct;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder preliminaryCheck(boolean preliminaryCheck) {
            this.preliminaryCheck = preliminaryCheck;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outliersCorrection(boolean outliersCorrection) {
            this.outliersCorrection = outliersCorrection;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder function(TransformationType function) {
            this.function = function;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder adjust(LengthOfPeriodType adjust) {
            this.adjust = adjust;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TransformSpec buildWithoutValidation() {
            return new TransformSpec(this.span, this.fct, this.preliminaryCheck, this.outliersCorrection, this.function, this.adjust);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TransformSpec.Builder(span=" + String.valueOf(this.span) + ", fct=" + this.fct + ", preliminaryCheck=" + this.preliminaryCheck + ", outliersCorrection=" + this.outliersCorrection + ", function=" + String.valueOf(this.function) + ", adjust=" + String.valueOf(this.adjust) + ")";
        }
    }
}

