/*
 * Decompiled with CFR 0.152.
 */
package beagle;

import beagle.GeneralBeagleImpl;
import java.util.logging.Logger;

public class FourStateBeagleImpl
extends GeneralBeagleImpl {
    public static final boolean DEBUG = false;

    public FourStateBeagleImpl(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, 4, n4, n5, n6, n7, n8);
        Logger.getLogger("beagle").info("Constructing double-precision 4-state Java BEAGLE implementation.");
    }

    @Override
    protected int updateStatesStates(int n, int n2, int n3, int n4, int n5) {
        int n6;
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        int[] nArray = this.tipStates[n];
        int[] nArray2 = this.tipStates[n3];
        double[] dArray3 = this.partials[n5];
        int[] nArray3 = this.scalingFactorCounts[n5];
        for (n6 = 0; n6 < nArray3.length; ++n6) {
            nArray3[n6] = 0;
        }
        int n7 = 0;
        n6 = 0;
        for (int i = 0; i < this.categoryCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                int n8 = n6;
                int n9 = nArray[j];
                int n10 = nArray2[j];
                if (n9 < 4 && n10 < 4) {
                    dArray3[n7] = dArray[n8 + n9] * dArray2[n8 + n10];
                    dArray3[++n7] = dArray[(n8 += 4) + n9] * dArray2[n8 + n10];
                    dArray3[++n7] = dArray[(n8 += 4) + n9] * dArray2[n8 + n10];
                    dArray3[++n7] = dArray[(n8 += 4) + n9] * dArray2[n8 + n10];
                    ++n7;
                    n8 += 4;
                    continue;
                }
                if (n9 < 4) {
                    dArray3[n7] = dArray[n8 + n9];
                    dArray3[++n7] = dArray[(n8 += 4) + n9];
                    dArray3[++n7] = dArray[(n8 += 4) + n9];
                    dArray3[++n7] = dArray[(n8 += 4) + n9];
                    ++n7;
                    n8 += 4;
                    continue;
                }
                if (n10 < 4) {
                    dArray3[n7] = dArray2[n8 + n10];
                    dArray3[++n7] = dArray2[(n8 += 4) + n10];
                    dArray3[++n7] = dArray2[(n8 += 4) + n10];
                    dArray3[++n7] = dArray2[(n8 += 4) + n10];
                    ++n7;
                    n8 += 4;
                    continue;
                }
                dArray3[n7] = 1.0;
                dArray3[++n7] = 1.0;
                dArray3[++n7] = 1.0;
                dArray3[++n7] = 1.0;
                ++n7;
            }
            n6 += this.matrixSize;
        }
        return 0;
    }

    @Override
    protected int updateStatesPartials(int n, int n2, int n3, int n4, int n5) {
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        int[] nArray = this.tipStates[n];
        double[] dArray3 = this.partials[n3];
        double[] dArray4 = this.partials[n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int[] nArray2 = this.scalingFactorCounts[n3];
        int[] nArray3 = this.scalingFactorCounts[n5];
        System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
        for (int i = 0; i < this.categoryCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                double d;
                int n10 = nArray[j];
                if (n10 < 4) {
                    d = dArray2[n8] * dArray3[n7];
                    d += dArray2[n8 + 1] * dArray3[n7 + 1];
                    d += dArray2[n8 + 2] * dArray3[n7 + 2];
                    dArray4[n6] = dArray[n8 + n10] * (d += dArray2[n8 + 3] * dArray3[n7 + 3]);
                    n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                    d = dArray2[n8 + 4] * dArray3[n7];
                    d += dArray2[n8 + 5] * dArray3[n7 + 1];
                    d += dArray2[n8 + 6] * dArray3[n7 + 2];
                    dArray4[++n6] = dArray[n8 + 4 + n10] * (d += dArray2[n8 + 7] * dArray3[n7 + 3]);
                    n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                    d = dArray2[n8 + 8] * dArray3[n7];
                    d += dArray2[n8 + 9] * dArray3[n7 + 1];
                    d += dArray2[n8 + 10] * dArray3[n7 + 2];
                    dArray4[++n6] = dArray[n8 + 8 + n10] * (d += dArray2[n8 + 11] * dArray3[n7 + 3]);
                    n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                    d = dArray2[n8 + 12] * dArray3[n7];
                    d += dArray2[n8 + 13] * dArray3[n7 + 1];
                    d += dArray2[n8 + 14] * dArray3[n7 + 2];
                    dArray4[++n6] = dArray[n8 + 12 + n10] * (d += dArray2[n8 + 15] * dArray3[n7 + 3]);
                    n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                    ++n6;
                    n7 += 4;
                    continue;
                }
                d = dArray2[n8] * dArray3[n7];
                d += dArray2[n8 + 1] * dArray3[n7 + 1];
                d += dArray2[n8 + 2] * dArray3[n7 + 2];
                dArray4[n6] = d += dArray2[n8 + 3] * dArray3[n7 + 3];
                n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                d = dArray2[n8 + 4] * dArray3[n7];
                d += dArray2[n8 + 5] * dArray3[n7 + 1];
                d += dArray2[n8 + 6] * dArray3[n7 + 2];
                dArray4[++n6] = d += dArray2[n8 + 7] * dArray3[n7 + 3];
                n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                d = dArray2[n8 + 8] * dArray3[n7];
                d += dArray2[n8 + 9] * dArray3[n7 + 1];
                d += dArray2[n8 + 10] * dArray3[n7 + 2];
                dArray4[++n6] = d += dArray2[n8 + 11] * dArray3[n7 + 3];
                n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                d = dArray2[n8 + 12] * dArray3[n7];
                d += dArray2[n8 + 13] * dArray3[n7 + 1];
                d += dArray2[n8 + 14] * dArray3[n7 + 2];
                dArray4[++n6] = d += dArray2[n8 + 15] * dArray3[n7 + 3];
                n9 |= Math.abs(Math.getExponent(dArray4[n6]));
                ++n6;
                n7 += 4;
            }
            n8 += this.matrixSize;
        }
        return n9;
    }

    @Override
    protected int updatePartialsPartials(int n, int n2, int n3, int n4, int n5) {
        double[] dArray = this.matrices[n2];
        double[] dArray2 = this.matrices[n4];
        double[] dArray3 = this.partials[n];
        double[] dArray4 = this.partials[n3];
        double[] dArray5 = this.partials[n5];
        int[] nArray = this.scalingFactorCounts[n];
        int[] nArray2 = this.scalingFactorCounts[n3];
        int[] nArray3 = this.scalingFactorCounts[n5];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = nArray[i] + nArray2[i];
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < this.categoryCount; ++i) {
            for (int j = 0; j < this.patternCount; ++j) {
                double d = dArray[n8] * dArray3[n7];
                double d2 = dArray2[n8] * dArray4[n7];
                d += dArray[n8 + 1] * dArray3[n7 + 1];
                d2 += dArray2[n8 + 1] * dArray4[n7 + 1];
                d += dArray[n8 + 2] * dArray3[n7 + 2];
                d2 += dArray2[n8 + 2] * dArray4[n7 + 2];
                dArray5[n6] = (d += dArray[n8 + 3] * dArray3[n7 + 3]) * (d2 += dArray2[n8 + 3] * dArray4[n7 + 3]);
                n9 |= Math.abs(Math.getExponent(dArray5[n6]));
                ++n6;
                d = dArray[n8 + 4] * dArray3[n7];
                d2 = dArray2[n8 + 4] * dArray4[n7];
                d += dArray[n8 + 5] * dArray3[n7 + 1];
                d2 += dArray2[n8 + 5] * dArray4[n7 + 1];
                d += dArray[n8 + 6] * dArray3[n7 + 2];
                d2 += dArray2[n8 + 6] * dArray4[n7 + 2];
                dArray5[n6] = (d += dArray[n8 + 7] * dArray3[n7 + 3]) * (d2 += dArray2[n8 + 7] * dArray4[n7 + 3]);
                n9 |= Math.abs(Math.getExponent(dArray5[n6]));
                ++n6;
                d = dArray[n8 + 8] * dArray3[n7];
                d2 = dArray2[n8 + 8] * dArray4[n7];
                d += dArray[n8 + 9] * dArray3[n7 + 1];
                d2 += dArray2[n8 + 9] * dArray4[n7 + 1];
                d += dArray[n8 + 10] * dArray3[n7 + 2];
                d2 += dArray2[n8 + 10] * dArray4[n7 + 2];
                dArray5[n6] = (d += dArray[n8 + 11] * dArray3[n7 + 3]) * (d2 += dArray2[n8 + 11] * dArray4[n7 + 3]);
                n9 |= Math.abs(Math.getExponent(dArray5[n6]));
                ++n6;
                d = dArray[n8 + 12] * dArray3[n7];
                d2 = dArray2[n8 + 12] * dArray4[n7];
                d += dArray[n8 + 13] * dArray3[n7 + 1];
                d2 += dArray2[n8 + 13] * dArray4[n7 + 1];
                d += dArray[n8 + 14] * dArray3[n7 + 2];
                d2 += dArray2[n8 + 14] * dArray4[n7 + 2];
                dArray5[n6] = (d += dArray[n8 + 15] * dArray3[n7 + 3]) * (d2 += dArray2[n8 + 15] * dArray4[n7 + 3]);
                n9 |= Math.abs(Math.getExponent(dArray5[n6]));
                ++n6;
                n7 += 4;
            }
            n8 += this.matrixSize;
        }
        return n9;
    }

    @Override
    public void calculateRootLogLikelihoods(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, double[] dArray) {
        int n2;
        double[] dArray2 = this.partials[nArray[0]];
        double[] dArray3 = this.categoryWeights[nArray2[0]];
        double[] dArray4 = this.stateFrequencies[nArray3[0]];
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.patternCount; ++n2) {
            this.tmpPartials[n3] = dArray2[n4] * dArray3[0];
            this.tmpPartials[++n3] = dArray2[++n4] * dArray3[0];
            this.tmpPartials[++n3] = dArray2[++n4] * dArray3[0];
            this.tmpPartials[++n3] = dArray2[++n4] * dArray3[0];
            ++n3;
            ++n4;
        }
        for (n2 = 1; n2 < this.categoryCount; ++n2) {
            n3 = 0;
            for (int i = 0; i < this.patternCount; ++i) {
                int n5 = n3++;
                this.tmpPartials[n5] = this.tmpPartials[n5] + dArray2[n4] * dArray3[n2];
                int n6 = n3++;
                this.tmpPartials[n6] = this.tmpPartials[n6] + dArray2[++n4] * dArray3[n2];
                int n7 = n3++;
                this.tmpPartials[n7] = this.tmpPartials[n7] + dArray2[++n4] * dArray3[n2];
                int n8 = n3++;
                this.tmpPartials[n8] = this.tmpPartials[n8] + dArray2[++n4] * dArray3[n2];
                ++n4;
            }
        }
        dArray[0] = 0.0;
        n4 = 0;
        for (n2 = 0; n2 < this.patternCount; ++n2) {
            double d = dArray4[0] * this.tmpPartials[n4];
            d += dArray4[1] * this.tmpPartials[++n4];
            d += dArray4[2] * this.tmpPartials[++n4];
            d += dArray4[3] * this.tmpPartials[++n4];
            ++n4;
            dArray[0] = dArray[0] + Math.log(d) * this.patternWeights[n2];
        }
        int[] nArray5 = this.scalingFactorCounts[nArray[0]];
        for (int i = 0; i < 254; ++i) {
            dArray[0] = dArray[0] - (double)nArray5[i] * this.logScalingFactors[i];
        }
    }
}

