/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.randvar.RandUnuran;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class UnuranDiscreteInt
extends RandomVariateGenInt {
    private RandUnuran unuran = new RandUnuran();

    public UnuranDiscreteInt(RandomStream s, String genStr) {
        if (s == null) {
            throw new IllegalArgumentException("mainStream must not be null.");
        }
        this.unuran.mainStream = this.unuran.auxStream = s;
        this.unuran.init(genStr);
        if (!this.unuran.isDiscrete()) {
            this.unuran.close();
            throw new IllegalArgumentException("not a discrete distribution");
        }
    }

    public UnuranDiscreteInt(RandomStream s, RandomStream aux, String genStr) {
        if (s == null) {
            throw new IllegalArgumentException("mainStream must not be null.");
        }
        if (aux == null) {
            throw new IllegalArgumentException("auxStream must not be null.");
        }
        this.unuran.mainStream = s;
        this.unuran.auxStream = aux;
        this.unuran.init(genStr);
        if (!this.unuran.isDiscrete()) {
            this.unuran.close();
            throw new IllegalArgumentException("not a discrete distribution");
        }
    }

    public int nextInt() {
        if (this.unuran.nativeParams == 0) {
            throw new IllegalStateException();
        }
        return this.unuran.getRandDisc(this.unuran.mainStream.nextDouble(), this.unuran.nativeParams);
    }

    public void nextArrayOfInt(int[] v, int start, int n) {
        if (v == null || start < 0 || n < 0 || start + n > v.length) {
            throw new IllegalArgumentException();
        }
        if (this.unuran.unifArray == null || this.unuran.unifArray.length < n) {
            this.unuran.unifArray = new double[n];
        }
        if (this.unuran.mainStream != this.unuran.auxStream && (this.unuran.unifAuxArray == null || this.unuran.unifAuxArray.length < n)) {
            this.unuran.unifAuxArray = new double[n];
        }
        this.unuran.getRandDiscArray(this.unuran.nativeParams, this.unuran.unifArray, this.unuran.unifAuxArray, v, start, n);
    }

    protected void finalize() {
        this.unuran.close();
    }

    public DiscreteDistributionInt getDistribution() {
        return null;
    }

    public RandomStream getStream() {
        return this.unuran.mainStream;
    }

    public RandomStream getAuxStream() {
        return this.unuran.auxStream;
    }
}

