/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Label;
import cc.mallet.types.RankedFeatureVector;
import cc.mallet.util.StatFunctions;

public class BiNormalSeparation
extends RankedFeatureVector {
    private static final double BNS_MIN_RATE = 5.0E-4;
    private static final double BNS_MAX_RATE = 0.9995;

    private static double[] calculateWeights(InstanceList instanceList) {
        int numFeatures = instanceList.getAlphabet().size();
        double[] weights = new double[numFeatures];
        double[] truePositives = new double[numFeatures];
        double[] falsePositives = new double[numFeatures];
        double numPos = 0.0;
        double numNeg = 0.0;
        Label posLabel = null;
        for (Instance instance : instanceList) {
            if (posLabel == null) {
                posLabel = (Label)instance.getTarget();
            }
            boolean isPos = false;
            if (posLabel.equals(instance.getTarget())) {
                isPos = true;
                numPos += 1.0;
            } else {
                numNeg += 1.0;
            }
            FeatureVector fv = (FeatureVector)instance.getData();
            for (int index : fv.getIndices()) {
                if (isPos) {
                    int n = index;
                    truePositives[n] = truePositives[n] + 1.0;
                    continue;
                }
                int n = index;
                falsePositives[n] = falsePositives[n] + 1.0;
            }
        }
        for (int i = 0; i < numFeatures; ++i) {
            double tpr = 0.5;
            if (numPos > 0.0) {
                tpr = Math.max(Math.min(0.9995, truePositives[i] / numPos), 5.0E-4);
            }
            double fpr = 0.5;
            if (numNeg > 0.0) {
                fpr = Math.max(Math.min(0.9995, falsePositives[i] / numNeg), 5.0E-4);
            }
            weights[i] = Math.abs(StatFunctions.qnorm(tpr, false) - StatFunctions.qnorm(fpr, false));
        }
        return weights;
    }

    public BiNormalSeparation(InstanceList ilist) {
        super(ilist.getDataAlphabet(), BiNormalSeparation.calculateWeights(ilist));
    }

    public static class Factory
    implements RankedFeatureVector.Factory {
        @Override
        public RankedFeatureVector newRankedFeatureVector(InstanceList instanceList) {
            return new BiNormalSeparation(instanceList);
        }
    }
}

