/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaUtil;
import org.jpmml.rexp.ModelFrameFormulaContext;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RStringVector;

public abstract class MixtureModelConverter
extends Converter<RGenericVector> {
    private ContinuousLabel label = null;
    protected static final String NAME_COUNT = "count";
    protected static final String NAME_FULL = "full";
    protected static final String NAME_ZERO = "zero";

    public MixtureModelConverter(RGenericVector object) {
        super(object);
    }

    protected abstract Model encodeZeroComponent(List<Feature> var1, List<Double> var2, Double var3, Schema var4);

    protected abstract Model encodeCountComponent(List<Feature> var1, List<Double> var2, Double var3, Schema var4);

    protected Model encodeComponent(String name, RExpEncoder encoder) {
        RGenericVector object = (RGenericVector)this.getObject();
        RDoubleVector coefficients = object.getGenericElement("coefficients").getDoubleElement(name);
        RExp terms = (RExp)object.getGenericElement("terms").getElement(name);
        RGenericVector model = object.getGenericElement("model");
        RStringVector coefficientNames = coefficients.names();
        ModelFrameFormulaContext context = new ModelFrameFormulaContext(model);
        Formula formula = FormulaUtil.createFormula(terms, context, encoder);
        switch (name) {
            case "count": {
                FormulaUtil.setLabel(formula, terms, null, encoder);
                ContinuousLabel continuousLabel = (ContinuousLabel)encoder.getLabel();
                DataField dataField = (DataField)encoder.getField(continuousLabel.getName());
                dataField.setDataType(DataType.DOUBLE);
                this.setLabel(new ContinuousLabel((Field)dataField));
                break;
            }
            case "zero": {
                break;
            }
            default: {
                throw new IllegalArgumentException(name);
            }
        }
        encoder.setLabel((Label)new ContinuousLabel(DataType.DOUBLE));
        List<Feature> features = encoder.getFeatures();
        if (!features.isEmpty()) {
            features.clear();
        }
        List<String> names = FormulaUtil.removeSpecialSymbol(coefficientNames.getDequotedValues(), "(Intercept)");
        FormulaUtil.addFeatures(formula, names, true, encoder);
        features = encoder.getFeatures();
        Schema schema = encoder.createSchema();
        Double intercept = (Double)coefficients.getElement("(Intercept)", false);
        SchemaUtil.checkSize((int)(coefficients.size() - (intercept != null ? 1 : 0)), features);
        ArrayList<Double> featureCoefficients = new ArrayList<Double>();
        for (Feature feature : features) {
            Double coefficient = formula.getCoefficient(feature, coefficients);
            featureCoefficients.add(coefficient);
        }
        switch (name) {
            case "zero": {
                return this.encodeZeroComponent(features, featureCoefficients, intercept, schema);
            }
            case "count": {
                return this.encodeCountComponent(features, featureCoefficients, intercept, schema);
            }
        }
        throw new IllegalArgumentException(name);
    }

    protected Model encodeTarget(DerivedField derivedField, Map<String, OutputField> outputFields, RExpEncoder encoder) {
        ContinuousLabel label = this.getLabel();
        ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
        Schema targetSchema = new Schema((ModelEncoder)encoder, (Label)label, Collections.emptyList());
        Output output = new Output();
        Set<Map.Entry<String, OutputField>> entries = outputFields.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            OutputField outputField = (OutputField)entry.getValue();
            OutputField targetOutputField = new OutputField(name, outputField.requireOpType(), outputField.requireDataType()).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setExpression((Expression)new FieldRef((Field)outputField));
            output.addOutputFields(new OutputField[]{targetOutputField});
        }
        RegressionModel regressionModel = RegressionModelUtil.createRegression(Collections.singletonList(feature), Collections.singletonList(1.0), null, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (Schema)targetSchema).setOutput(output);
        return regressionModel;
    }

    protected ContinuousLabel getLabel() {
        return this.label;
    }

    private void setLabel(ContinuousLabel label) {
        this.label = label;
    }
}

