/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.languagemodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.languagemodel.NGramLanguageModel;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.StringList;

public class NGramLanguageModelTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "gives the probability and most probable next token(s) of a sequence of tokens in a language model";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String[] args) {
        File lmFile = new File(args[0]);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(lmFile);
            NGramLanguageModel nGramLanguageModel = new NGramLanguageModel(stream);
            PerformanceMonitor perfMon = null;
            try {
                String line;
                PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());
                perfMon = new PerformanceMonitor(System.err, "nglm");
                perfMon.start();
                while ((line = (String)lineStream.read()) != null) {
                    StringList predicted;
                    double probability;
                    String[] tokens = line.split(" ");
                    StringList sample = new StringList(tokens);
                    try {
                        probability = nGramLanguageModel.calculateProbability(sample);
                        predicted = nGramLanguageModel.predictNextTokens(sample);
                    }
                    catch (Exception e) {
                        System.err.println("Error:" + e.getLocalizedMessage());
                        System.err.println(line);
                        continue;
                    }
                    System.out.println(sample + " -> prob:" + probability + ", next:" + predicted);
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model";
    }
}

