/*
 * Decompiled with CFR 0.152.
 */
package moa.options;

import com.github.javacliparser.Option;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import moa.options.AbstractClassOption;
import moa.tasks.Task;
import weka.core.OptionHandler;
import weka.core.Utils;

public class WEKAClassOption
extends AbstractClassOption {
    private static final long serialVersionUID = 1L;

    public WEKAClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString) {
        super(name, cliChar, purpose, requiredType, defaultCLIString);
    }

    public WEKAClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString, String nullString) {
        super(name, cliChar, purpose, requiredType, defaultCLIString, nullString);
    }

    @Override
    public String getValueAsCLIString() {
        if (this.currentValue == null && this.nullString != null) {
            return this.nullString;
        }
        String result = this.currentValue.getClass().getName();
        if (this.currentValue instanceof OptionHandler) {
            result = result + " " + Utils.joinOptions((String[])((OptionHandler)this.currentValue).getOptions());
        }
        result = result.trim();
        return result;
    }

    @Override
    public void setValueViaCLIString(String s) {
        if (this.nullString != null && (s == null || s.length() == 0 || s.equals(this.nullString))) {
            this.currentValue = null;
        } else {
            try {
                this.currentValue = WEKAClassOption.cliStringToObject(s, this.requiredType, null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problems with option: " + this.getName(), e);
            }
        }
    }

    public static String objectToCLIString(Object obj, Class<?> requiredType) {
        String subOptions;
        if (obj == null) {
            return "";
        }
        if (obj instanceof File) {
            return "file:" + ((File)obj).getPath();
        }
        if (obj instanceof String) {
            return "inmem:" + obj;
        }
        String className = WEKAClassOption.classToCLIString(obj.getClass(), requiredType);
        if (obj instanceof OptionHandler && (subOptions = Utils.joinOptions((String[])((OptionHandler)obj).getOptions())).length() > 0) {
            return new String(className + " " + subOptions).trim();
        }
        return className;
    }

    public static Object cliStringToObject(String cliString, Class<?> requiredType, Option[] externalOptions) throws Exception {
        Object classInstance;
        Class<?> classObject;
        String WEKAClassOptions;
        String className;
        if (cliString.startsWith("file:")) {
            return new File(cliString.substring("file:".length()));
        }
        if (cliString.startsWith("inmem:")) {
            return cliString.substring("inmem:".length());
        }
        int firstSpaceIndex = (cliString = cliString.trim()).indexOf(32, 0);
        if (firstSpaceIndex > 0) {
            className = cliString.substring(0, firstSpaceIndex);
            WEKAClassOptions = cliString.substring(firstSpaceIndex + 1, cliString.length());
            WEKAClassOptions = WEKAClassOptions.trim();
        } else {
            className = cliString;
            WEKAClassOptions = "";
        }
        try {
            classObject = Class.forName(className);
        }
        catch (Throwable t1) {
            try {
                classObject = Class.forName(requiredType.getPackage().getName() + "." + className);
            }
            catch (Throwable t2) {
                try {
                    classObject = Class.forName(Task.class.getPackage().getName() + "." + className);
                }
                catch (Throwable t3) {
                    throw new Exception("Class not found: " + className);
                }
            }
        }
        try {
            classInstance = classObject.newInstance();
        }
        catch (Exception ex) {
            throw new Exception("Problem creating instance of class: " + className, ex);
        }
        if (requiredType.isInstance(classInstance) || classInstance instanceof Task && requiredType.isAssignableFrom(((Task)classInstance).getTaskResultType())) {
            Vector<String> options = new Vector<String>();
            if (externalOptions != null) {
                for (Option option : externalOptions) {
                    options.add(option.getValueAsCLIString());
                }
            } else {
                String[] optionsTmp = Utils.splitOptions((String)cliString);
                for (int i = 1; i < optionsTmp.length; ++i) {
                    options.add(optionsTmp[i]);
                }
            }
            if (classInstance instanceof OptionHandler) {
                try {
                    ((OptionHandler)classInstance).setOptions(options.toArray(new String[options.size()]));
                }
                catch (Exception ex) {
                    Enumeration enm = ((OptionHandler)classInstance).listOptions();
                    StringBuffer optionsText = new StringBuffer();
                    while (enm.hasMoreElements()) {
                        Option option;
                        option = (weka.core.Option)enm.nextElement();
                        optionsText.append(option.synopsis() + '\n');
                        optionsText.append(option.description() + "\n");
                    }
                    throw new Exception("Problem with options to '" + className + "'.\n\nValid options for " + className + ":\n" + optionsText.toString(), ex);
                }
            }
        } else {
            throw new Exception("Class named '" + className + "' is not an instance of " + requiredType.getName() + ".");
        }
        return classInstance;
    }
}

