/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import no.uib.cipr.matrix.distributed.Reduction;

public class Reductions {
    private Reductions() {
    }

    public static Reduction sum() {
        return new Sum();
    }

    public static Reduction product() {
        return new Product();
    }

    public static Reduction max() {
        return new Max();
    }

    public static Reduction min() {
        return new Min();
    }

    public static Reduction and() {
        return new And();
    }

    public static Reduction or() {
        return new Or();
    }

    private static class Or
    extends BooleanReduction {
        private Or() {
        }

        protected void initBoolean(boolean[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = false;
            }
        }

        protected void opBoolean(boolean[] x, boolean[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] | y[i];
            }
        }
    }

    private static class And
    extends BooleanReduction {
        private And() {
        }

        protected void initBoolean(boolean[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = true;
            }
        }

        protected void opBoolean(boolean[] x, boolean[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] & y[i];
            }
        }
    }

    private static abstract class BooleanReduction
    extends Reduction {
        private BooleanReduction() {
        }

        protected void initByte(byte[] x) {
            throw new UnsupportedOperationException();
        }

        protected void initChar(char[] x) {
            throw new UnsupportedOperationException();
        }

        protected void initShort(short[] x) {
            throw new UnsupportedOperationException();
        }

        protected void initInt(int[] x) {
            throw new UnsupportedOperationException();
        }

        protected void initFloat(float[] x) {
            throw new UnsupportedOperationException();
        }

        protected void initLong(long[] x) {
            throw new UnsupportedOperationException();
        }

        protected void initDouble(double[] x) {
            throw new UnsupportedOperationException();
        }

        protected void opByte(byte[] x, byte[] y) {
            throw new UnsupportedOperationException();
        }

        protected void opChar(char[] x, char[] y) {
            throw new UnsupportedOperationException();
        }

        protected void opShort(short[] x, short[] y) {
            throw new UnsupportedOperationException();
        }

        protected void opInt(int[] x, int[] y) {
            throw new UnsupportedOperationException();
        }

        protected void opFloat(float[] x, float[] y) {
            throw new UnsupportedOperationException();
        }

        protected void opLong(long[] x, long[] y) {
            throw new UnsupportedOperationException();
        }

        protected void opDouble(double[] x, double[] y) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class NumericalReduction
    extends Reduction {
        private NumericalReduction() {
        }

        protected void initBoolean(boolean[] x) {
            throw new UnsupportedOperationException();
        }

        protected void opBoolean(boolean[] x, boolean[] y) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Min
    extends NumericalReduction {
        private Min() {
        }

        protected void initByte(byte[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 127;
            }
        }

        protected void initChar(char[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 65535;
            }
        }

        protected void initShort(short[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Short.MAX_VALUE;
            }
        }

        protected void initInt(int[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Integer.MAX_VALUE;
            }
        }

        protected void initFloat(float[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Float.MAX_VALUE;
            }
        }

        protected void initLong(long[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Long.MAX_VALUE;
            }
        }

        protected void initDouble(double[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Double.MAX_VALUE;
            }
        }

        protected void opByte(byte[] x, byte[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (byte)Math.min(x[i], y[i]);
            }
        }

        protected void opChar(char[] x, char[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (char)Math.min(x[i], y[i]);
            }
        }

        protected void opShort(short[] x, short[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (short)Math.min(x[i], y[i]);
            }
        }

        protected void opInt(int[] x, int[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.min(x[i], y[i]);
            }
        }

        protected void opFloat(float[] x, float[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.min(x[i], y[i]);
            }
        }

        protected void opLong(long[] x, long[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.min(x[i], y[i]);
            }
        }

        protected void opDouble(double[] x, double[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.min(x[i], y[i]);
            }
        }
    }

    private static class Max
    extends NumericalReduction {
        private Max() {
        }

        protected void initByte(byte[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = -128;
            }
        }

        protected void initChar(char[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = '\u0000';
            }
        }

        protected void initShort(short[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Short.MIN_VALUE;
            }
        }

        protected void initInt(int[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Integer.MIN_VALUE;
            }
        }

        protected void initFloat(float[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Float.MIN_VALUE;
            }
        }

        protected void initLong(long[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Long.MIN_VALUE;
            }
        }

        protected void initDouble(double[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Double.MIN_VALUE;
            }
        }

        protected void opByte(byte[] x, byte[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (byte)Math.max(x[i], y[i]);
            }
        }

        protected void opChar(char[] x, char[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (char)Math.max(x[i], y[i]);
            }
        }

        protected void opShort(short[] x, short[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (short)Math.max(x[i], y[i]);
            }
        }

        protected void opInt(int[] x, int[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.max(x[i], y[i]);
            }
        }

        protected void opFloat(float[] x, float[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.max(x[i], y[i]);
            }
        }

        protected void opLong(long[] x, long[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.max(x[i], y[i]);
            }
        }

        protected void opDouble(double[] x, double[] y) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = Math.max(x[i], y[i]);
            }
        }
    }

    private static class Product
    extends NumericalReduction {
        private Product() {
        }

        protected void initByte(byte[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1;
            }
        }

        protected void initChar(char[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = '\u0001';
            }
        }

        protected void initShort(short[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1;
            }
        }

        protected void initInt(int[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1;
            }
        }

        protected void initFloat(float[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1.0f;
            }
        }

        protected void initLong(long[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1L;
            }
        }

        protected void initDouble(double[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 1.0;
            }
        }

        protected void opByte(byte[] x, byte[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = (byte)(x[n] * y[i]);
            }
        }

        protected void opChar(char[] x, char[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = (char)(x[n] * y[i]);
            }
        }

        protected void opShort(short[] x, short[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = (short)(x[n] * y[i]);
            }
        }

        protected void opInt(int[] x, int[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] * y[i];
            }
        }

        protected void opFloat(float[] x, float[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] * y[i];
            }
        }

        protected void opLong(long[] x, long[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] * y[i];
            }
        }

        protected void opDouble(double[] x, double[] y) {
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] * y[i];
            }
        }
    }

    private static class Sum
    extends NumericalReduction {
        private Sum() {
        }

        protected void initByte(byte[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0;
            }
        }

        protected void initChar(char[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = '\u0000';
            }
        }

        protected void initShort(short[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0;
            }
        }

        protected void initInt(int[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0;
            }
        }

        protected void initFloat(float[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0.0f;
            }
        }

        protected void initLong(long[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0L;
            }
        }

        protected void initDouble(double[] x) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = 0.0;
            }
        }

        protected void opByte(byte[] x, byte[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = (byte)(x[n] + y[i]);
            }
        }

        protected void opChar(char[] x, char[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = (char)(x[n] + y[i]);
            }
        }

        protected void opShort(short[] x, short[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = (short)(x[n] + y[i]);
            }
        }

        protected void opInt(int[] x, int[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + y[i];
            }
        }

        protected void opFloat(float[] x, float[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + y[i];
            }
        }

        protected void opLong(long[] x, long[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + y[i];
            }
        }

        protected void opDouble(double[] x, double[] y) {
            assert (x.length == y.length);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + y[i];
            }
        }
    }
}

