## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 8,
  fig.height = 6
)

## ----setup--------------------------------------------------------------------
library(QualityMeasure)

## -----------------------------------------------------------------------------
df <- psychreadmission
knitr::kable(head(df), 'simple')

## -----------------------------------------------------------------------------
marg.p = sum(df$n * df$rate) / (sum(df$n)) / 100

df$rank = rank(df$rate, ties.method = 'random')

profile.fig <- ggplot(data = df, aes(x = rank, y = rate)) +
  geom_point(color = 'black') +
  geom_errorbar(aes(ymin = rate.lwr, ymax = rate.upr), width = 0.1) +
  geom_hline(yintercept = marg.p * 100, col = 'red', lty = 'dashed', linewidth = 1.2, alpha = 0.7) +
  xlab('Hospital Rank') +
  ylab('Readmission Rate (%)') +
  theme_classic() +
  theme(
    axis.text = element_text(size = 16),
    axis.ticks.length = unit(.25, 'cm'),
    axis.title = element_text(size = 18, face = 'bold')
  )
profile.fig

## -----------------------------------------------------------------------------
knitr::kable(table(df$category), 'simple', col.names = c('Category', 'Count'))

