/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.util.ImmutableValueFactory;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOFunction;
import org.jspecify.annotations.Nullable;

public final class ImmutableValuePool<VALUE> {
    @NonNull
    private final ConcurrentMap<DataSource, VALUE> resources;

    @NonNull
    public static <VALUE> ImmutableValuePool<VALUE> of() {
        return new ImmutableValuePool(new ConcurrentHashMap());
    }

    @NonNull
    public VALUE get(@NonNull DataSource dataSource, @NonNull ImmutableValueFactory<VALUE> delegate) throws IOException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        try {
            return this.resources.computeIfAbsent(dataSource, IOFunction.unchecked(delegate::load));
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    public void remove(DataSource dataSource) {
        this.resources.remove(dataSource);
    }

    public void clear() {
        this.resources.clear();
    }

    public @Nullable VALUE peek(@NonNull DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        return (VALUE)this.resources.get(dataSource);
    }

    @NonNull
    public ImmutableValueFactory<VALUE> asFactory(@NonNull ImmutableValueFactory<VALUE> delegate) {
        Objects.requireNonNull(delegate);
        return dataSource -> this.get(dataSource, delegate);
    }

    @Generated
    public ImmutableValuePool(@NonNull ConcurrentMap<DataSource, VALUE> resources) {
        if (resources == null) {
            throw new NullPointerException("resources is marked non-null but is null");
        }
        this.resources = resources;
    }
}

