/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatException;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class DoornikHansen {
    private final DescriptiveStatistics stats;

    public DoornikHansen(DoubleSeq data) {
        this.stats = DescriptiveStatistics.of(data);
    }

    public DoornikHansen(DescriptiveStatistics stats) {
        this.stats = stats;
    }

    public StatisticalTest build() {
        double sk = this.stats.getSkewness();
        double n = this.stats.getDataCount();
        if (n <= 7.0) {
            throw new StatException("Not enough data");
        }
        double b = 3.0 * (n * n + 27.0 * n - 70.0) * (n + 1.0) * (n + 3.0) / ((n - 2.0) * (n + 5.0) * (n + 7.0) * (n + 9.0));
        double w2 = -1.0 + Math.sqrt(2.0 * (b - 1.0));
        double ds = 1.0 / Math.sqrt(0.5 * Math.log(w2));
        double y = sk * Math.sqrt((w2 - 1.0) * (n + 1.0) * (n + 3.0) / (12.0 * (n - 2.0)));
        double z1 = ds * Math.log(y + Math.sqrt(y * y + 1.0));
        double kr = this.stats.getKurtosis();
        double dk = (n - 3.0) * (n + 1.0) * (n * n + 15.0 * n - 4.0);
        double a = (n - 2.0) * (n + 5.0) * (n + 7.0) * (n * n + 27.0 * n - 70.0) / (dk * 6.0);
        double c = (n - 7.0) * (n + 5.0) * (n + 7.0) * (n * n + 2.0 * n - 5.0) / (dk * 6.0);
        double k = (n + 5.0) * (n + 7.0) * (n * n * n + n * n * 37.0 + 11.0 * n - 313.0) / (dk * 12.0);
        double alpha = a + c * sk * sk;
        double chi = 2.0 * k * (kr - 1.0 - sk * sk);
        double z2 = Math.sqrt(alpha * 9.0) * (Math.pow(chi / (2.0 * alpha), 0.3333333333333333) - 1.0 + 1.0 / (9.0 * alpha));
        return TestsUtility.testOf(z1 * z1 + z2 * z2, new Chi2(2.0), TestType.Upper);
    }
}

