## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, echo = FALSE------------------------------------------------------
library(pacta.multi.loanbook)

plot_table <- function(table) {
  table_plot <- gt::gt(dplyr::select(table, -"dataset"))
  
  table_plot <- 
    gt::cols_width(
      .data = table_plot,
      column ~ gt::px(150),
      typeof ~ gt::px(90)
    )
  
  table_plot <-
    gt::tab_style(
      data = table_plot,
      style = gt::cell_text(size = "smaller"),
      locations = gt::cells_body(columns = 1:2)
    )
  
  table_plot <-
    gt::tab_options(
      data = table_plot,
      ihtml.active = TRUE,
      ihtml.use_pagination = FALSE,
      ihtml.use_sorting = TRUE,
      ihtml.use_highlight = TRUE
    )
  
  gt::fmt_passthrough(table_plot)
}

## ----dd_lbk_match_success_rate, results = FALSE-------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "lbk_match_success_rate")

## ----dd_lbk_match_success_rate_table, echo = FALSE----------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "lbk_match_success_rate")
plot_table(table)

## ----dd_summary_statistics_loanbook_coverage, results = FALSE-----------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "summary_statistics_loanbook_coverage")

## ----dd_summary_statistics_loanbook_coverage_table, echo = FALSE--------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "summary_statistics_loanbook_coverage")
plot_table(table)

## ----dd_lost_companies_sector_split, results = FALSE--------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "lost_companies_sector_split")

## ----dd_lost_companies_sector_split_table, echo = FALSE-----------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "lost_companies_sector_split")
plot_table(table)

## ----dd_tms_results, results = FALSE------------------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "tms_results")

## ----dd_tms_results_table, echo = FALSE---------------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "tms_results")
plot_table(table)

## ----dd_sda_results, results = FALSE------------------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "sda_results")

## ----dd_sda_results_table, echo = FALSE---------------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "sda_results")
plot_table(table)

## ----dd_data_tech_mix, results = FALSE----------------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "data_tech_mix")

## ----dd_data_tech_mix_table, echo = FALSE-------------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "data_tech_mix")
plot_table(table)

## ----dd_data_trajectory, results = FALSE--------------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "data_trajectory")

## ----dd_data_trajectory_table, echo = FALSE-----------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "data_trajectory")
plot_table(table)

## ----dd_data_emission_intensity, results = FALSE------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "data_emission_intensity")

## ----dd_data_emission_intensity_table, echo = FALSE---------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "data_emission_intensity")
plot_table(table)

## ----dd_companies_included, results = FALSE-----------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "companies_included")

## ----dd_companies_included_table, echo = FALSE--------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "companies_included")
plot_table(table)

## ----dd_company_technology_deviation_tms, results = FALSE---------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "company_technology_deviation_tms")

## ----dd_company_technology_deviation_tms_table, echo = FALSE------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "company_technology_deviation_tms")
plot_table(table)

## ----dd_company_alignment_net_tms, results = FALSE----------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "company_alignment_net_tms")

## ----dd_company_alignment_net_tms_table, echo = FALSE-------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "company_alignment_net_tms")
plot_table(table)

## ----dd_company_alignment_bo_po_tms, results = FALSE--------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "company_alignment_bo_po_tms")

## ----dd_company_alignment_bo_po_tms_table, echo = FALSE-----------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "company_alignment_bo_po_tms")
plot_table(table)

## ----dd_company_alignment_net_sda, results = FALSE----------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "company_alignment_net_sda")

## ----dd_company_alignment_net_sda_table, echo = FALSE-------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "company_alignment_net_sda")
plot_table(table)

## ----dd_company_exposure_net_aggregate_alignment, results = FALSE-------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "company_exposure_net_aggregate_alignment")

## ----dd_company_exposure_net_aggregate_alignment_table, echo = FALSE----------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "company_exposure_net_aggregate_alignment")
plot_table(table)

## ----dd_company_exposure_bo_po_aggregate_alignment, results = FALSE-----------
dplyr::filter(data_dictionary, .data[["dataset"]] == "company_exposure_bo_po_aggregate_alignment")

## ----dd_company_exposure_bo_po_aggregate_alignment_table, echo = FALSE--------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "company_exposure_bo_po_aggregate_alignment")
plot_table(table)

## ----dd_loanbook_exposure_net_aggregate_alignment, results = FALSE------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "loanbook_exposure_net_aggregate_alignment")

## ----dd_loanbook_exposure_net_aggregate_alignment_table, echo = FALSE---------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "loanbook_exposure_net_aggregate_alignment")
plot_table(table)

## ----dd_loanbook_exposure_bo_po_aggregate_alignment, results = FALSE----------
dplyr::filter(data_dictionary, .data[["dataset"]] == "loanbook_exposure_bo_po_aggregate_alignment")

## ----dd_loanbook_exposure_bo_po_aggregate_alignment_table, echo = FALSE-------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "loanbook_exposure_bo_po_aggregate_alignment")
plot_table(table)

## ----dd_data_sankey, results = FALSE------------------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "data_sankey")

## ----dd_data_sankey_table, echo = FALSE---------------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "data_sankey")
plot_table(table)

## ----dd_data_scatter_alignment_exposure, results = FALSE----------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "data_scatter_alignment_exposure")

## ----dd_data_scatter_alignment_exposure_table, echo = FALSE-------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "data_scatter_alignment_exposure")
plot_table(table)

## ----dd_data_scatter_sector, results = FALSE----------------------------------
dplyr::filter(data_dictionary, .data[["dataset"]] == "data_scatter_sector")

## ----dd_data_scatter_sector_table, echo = FALSE-------------------------------
table <- dplyr::filter(data_dictionary, .data[["dataset"]] == "data_scatter_sector")
plot_table(table)

