/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.IntCircularQueue;
import org.chocosolver.util.tools.ArrayUtils;

public class PropMinCostMaxFlow
extends Propagator<IntVar> {
    private final int offset;
    private final int[] starts;
    private final int[] ends;
    private final int[] balances;
    private final int[] weights;
    private final IntVar[] flows;
    private final IntVar cost;
    private final Residual g;

    public PropMinCostMaxFlow(int[] starts, int[] ends, int[] balances, int[] weights, IntVar[] flows, IntVar cost, int offset) {
        super((Variable[])ArrayUtils.append(flows, {cost}), (Priority)PropagatorPriority.QUADRATIC, false);
        this.offset = offset;
        this.starts = starts;
        this.ends = ends;
        this.balances = balances;
        this.weights = weights;
        this.flows = flows;
        this.cost = cost;
        this.g = new Residual();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            this.g.refresh(-1, 0);
            int minCost = this.minCostFlow(-1, 0);
            if (minCost == -1) {
                this.fails();
            }
            this.cost.updateLowerBound(minCost, (ICause)this);
            int maxcost = this.cost.getUB();
            for (int i = 0; i < this.flows.length; ++i) {
                hasChanged |= this.updateFlow(i, maxcost);
            }
        }
    }

    private boolean updateFlow(int i, int maxcost) throws ContradictionException {
        int u;
        int l = this.flows[i].getLB();
        int m = u = this.flows[i].getUB();
        this.g.refresh(i, m);
        int c = this.minCostFlow(i, m);
        if (c > maxcost || c == -1) {
            --u;
            while (l <= u) {
                m = l + u >>> 1;
                this.g.refresh(i, m);
                c = this.minCostFlow(i, m);
                if (c == -1 || c > maxcost) {
                    u = m - 1;
                    continue;
                }
                l = m + 1;
            }
            return this.flows[i].updateUpperBound(u, (ICause)this) && u > this.flows[i].getUB();
        }
        return false;
    }

    private void shortest_paths(int s) {
        Arrays.fill(this.g.d, Integer.MAX_VALUE);
        Arrays.fill(this.g.p, -1);
        this.g.d[s] = 0;
        this.g.queue.clear();
        this.g.queue.addLast(s);
        while (!this.g.queue.isEmpty()) {
            int u = this.g.queue.pollFirst();
            for (int i = 0; i < this.g.adj[u].size(); ++i) {
                Edge e = this.g.adj[u].get(i);
                int v = e.to;
                if (e.capacity <= 0 || this.g.d[v] <= this.g.d[u] + e.cost) continue;
                this.g.d[v] = this.g.d[u] + e.cost;
                this.g.p[v] = e.id;
                this.g.queue.addLast(v);
            }
        }
    }

    private int minCostFlow(int a, int v) {
        int fl = 0;
        int cost = 0;
        while (fl < this.g.D) {
            Edge e;
            this.shortest_paths(this.g.s);
            if (this.g.d[this.g.t] == Integer.MAX_VALUE) break;
            int f = this.g.D - fl;
            int cur = this.g.p[this.g.t];
            while (cur != -1) {
                e = this.g.edges[cur];
                f = Math.min(f, e.capacity);
                cur = this.g.p[e.from];
            }
            fl += f;
            cost += f * this.g.d[this.g.t];
            cur = this.g.p[this.g.t];
            while (cur != -1) {
                e = this.g.edges[cur];
                e.capacity -= f;
                this.g.edges[e.rId].capacity += f;
                cur = this.g.p[e.from];
            }
        }
        if (fl < this.g.D) {
            return -1;
        }
        for (int i = 0; i < this.starts.length; ++i) {
            if (a == i) {
                cost += v * this.g.edges[i].cost;
                continue;
            }
            cost += this.flows[i].getLB() * this.g.edges[i].cost;
        }
        return cost;
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    private final class Residual {
        final int n;
        final int n2;
        final int m;
        final int s;
        final int t;
        final Edge[] edges;
        final List<Edge>[] adj;
        final int[] d;
        final int[] p;
        final int[] b;
        final IntCircularQueue queue;
        int D;

        public Residual() {
            int i;
            this.s = PropMinCostMaxFlow.this.balances.length;
            this.t = this.s + 1;
            this.n = PropMinCostMaxFlow.this.balances.length + 2;
            this.n2 = this.n - 2;
            this.d = new int[this.n];
            this.p = new int[this.n];
            this.queue = new IntCircularQueue(this.n);
            this.adj = new ArrayList[this.n];
            this.b = new int[this.n];
            for (i = 0; i < this.n; ++i) {
                this.adj[i] = new ArrayList<Edge>();
                if (i >= this.n - 2) continue;
                if (PropMinCostMaxFlow.this.balances[i] > 0) {
                    int n = this.s;
                    this.b[n] = this.b[n] + PropMinCostMaxFlow.this.balances[i];
                    continue;
                }
                if (PropMinCostMaxFlow.this.balances[i] >= 0) continue;
                int n = this.t;
                this.b[n] = this.b[n] + PropMinCostMaxFlow.this.balances[i];
            }
            this.m = PropMinCostMaxFlow.this.starts.length + 2 * this.n2;
            this.edges = new Edge[this.m * 2];
            for (i = 0; i < PropMinCostMaxFlow.this.starts.length; ++i) {
                int f = PropMinCostMaxFlow.this.starts[i] - PropMinCostMaxFlow.this.offset;
                int t = PropMinCostMaxFlow.this.ends[i] - PropMinCostMaxFlow.this.offset;
                int cost = PropMinCostMaxFlow.this.weights[i];
                this.edges[i] = new Edge(i, f, t, 0, cost, i + this.m);
                this.adj[f].add(this.edges[i]);
                this.edges[i + this.m] = new Edge(i + this.m, t, f, 0, -cost, i);
                this.adj[t].add(this.edges[i + this.m]);
            }
            i = 0;
            int k = PropMinCostMaxFlow.this.starts.length;
            while (i < this.n2) {
                this.edges[k] = new Edge(k, this.s, i, 0, 0, k + this.m);
                this.adj[this.s].add(this.edges[k]);
                this.edges[k + this.m] = new Edge(k + this.m, i, this.s, 0, 0, k);
                this.adj[i].add(this.edges[k + this.m]);
                this.edges[k + this.n2] = new Edge(k + this.n2, i, this.t, 0, 0, k + this.n2 + this.m);
                this.adj[i].add(this.edges[k + this.n2]);
                this.edges[k + this.n2 + this.m] = new Edge(k + this.n2 + this.m, this.t, i, 0, 0, k + this.n2);
                this.adj[this.t].add(this.edges[k + this.n2 + this.m]);
                ++i;
                ++k;
            }
        }

        public void refresh(int a, int v) {
            Arrays.fill(this.b, 0);
            System.arraycopy(PropMinCostMaxFlow.this.balances, 0, this.b, 0, PropMinCostMaxFlow.this.balances.length);
            for (int i = 0; i < PropMinCostMaxFlow.this.starts.length; ++i) {
                int f = PropMinCostMaxFlow.this.starts[i] - PropMinCostMaxFlow.this.offset;
                int t = PropMinCostMaxFlow.this.ends[i] - PropMinCostMaxFlow.this.offset;
                int lowerCap = PropMinCostMaxFlow.this.flows[i].getLB();
                int upperCap = PropMinCostMaxFlow.this.flows[i].getUB();
                if (a == i) {
                    lowerCap = v;
                }
                int n = f;
                this.b[n] = this.b[n] - lowerCap;
                int n2 = t;
                this.b[n2] = this.b[n2] + lowerCap;
                this.edges[i].capacity = upperCap - lowerCap;
                this.edges[i + this.m].capacity = 0;
                this.edges[i + this.m].flow = 0;
                this.edges[i].flow = 0;
            }
            int dIn = 0;
            int dOut = 0;
            int i = 0;
            int k = PropMinCostMaxFlow.this.starts.length;
            while (i < this.n2) {
                int b_;
                this.edges[k + this.n2 + this.m].capacity = 0;
                this.edges[k + this.n2].capacity = 0;
                this.edges[k + this.m].capacity = 0;
                this.edges[k].capacity = 0;
                this.edges[k + this.n2 + this.m].flow = 0;
                this.edges[k + this.n2].flow = 0;
                this.edges[k + this.m].flow = 0;
                this.edges[k].flow = 0;
                if (this.b[i] > 0) {
                    b_ = this.b[i];
                    int n = this.edges[k].from;
                    this.b[n] = this.b[n] + b_;
                    int n3 = this.edges[k].to;
                    this.b[n3] = this.b[n3] - b_;
                    this.edges[k].capacity = b_;
                    dIn += b_;
                } else if (this.b[i] < 0) {
                    b_ = this.b[i];
                    int n = this.edges[k + this.n2].from;
                    this.b[n] = this.b[n] - b_;
                    int n4 = this.edges[k + this.n2].to;
                    this.b[n4] = this.b[n4] + b_;
                    this.edges[k + this.n2].capacity = -b_;
                    dOut -= b_;
                }
                ++i;
                ++k;
            }
            assert (dIn == dOut);
            this.D = dIn;
        }
    }

    private static final class Edge {
        final int id;
        final int from;
        final int to;
        int capacity;
        int flow;
        final int cost;
        final int rId;

        public Edge(int id, int from, int to, int capacity, int cost, int rId) {
            this.id = id;
            this.from = from;
            this.to = to;
            this.capacity = capacity;
            this.cost = cost;
            this.rId = rId;
        }

        public String toString() {
            return "E#" + this.id + ": (" + this.from + "," + this.to + ") ca=" + this.capacity + ", co=" + this.cost + " -- " + this.rId;
        }
    }
}

