/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.random;

import java.util.Date;
import jdplus.toolkit.base.core.random.AbstractRNG;

public class MersenneTwister
extends AbstractRNG {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int mag0 = 0;
    private static final int mag1 = -1727483681;
    private int mti;
    private final int[] mt = new int[624];

    public static MersenneTwister fromSystemNanoTime() {
        return new MersenneTwister((int)System.nanoTime());
    }

    public static MersenneTwister fromDate(Date date) {
        return new MersenneTwister((int)date.getTime());
    }

    public MersenneTwister(int seed) {
        this.setSeed(seed);
    }

    protected void nextBlock() {
        int y;
        int kk;
        for (kk = 0; kk < 227; ++kk) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        }
        while (kk < 623) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + 397 - 624] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
            ++kk;
        }
        y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
        this.mt[623] = this.mt[396] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        this.mti = 0;
    }

    public int nextInt() {
        if (this.mti == 624) {
            this.nextBlock();
        }
        int y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    protected final void setSeed(int seed) {
        if (seed == 0) {
            seed = 123456;
        }
        this.mt[0] = seed & 0xFFFFFFFF;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1] & 0xFFFFFFFF;
            ++this.mti;
        }
    }
}

