/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.oldevomodel.clock.RateEvolutionLikelihood;

public class RateSampleOperator
extends SimpleMCMCOperator {
    private TreeModel tree;
    private boolean sampleAll;
    RateEvolutionLikelihood rateEvolution;

    public RateSampleOperator(TreeModel treeModel, boolean bl, RateEvolutionLikelihood rateEvolutionLikelihood) {
        this.tree = treeModel;
        this.sampleAll = bl;
        this.rateEvolution = rateEvolutionLikelihood;
    }

    @Override
    public final double doOperation() {
        int n;
        if (this.sampleAll) {
            n = this.tree.getRoot().getNumber();
        } else {
            while (this.tree.isExternal(this.tree.getNode(n = MathUtils.nextInt(this.tree.getNodeCount())))) {
            }
        }
        double d = this.rateEvolution.getLogLikelihood();
        this.sampleNode(this.tree.getNode(n));
        double d2 = this.rateEvolution.getLogLikelihood();
        return d - d2;
    }

    void sampleSubtree(NodeRef nodeRef) {
        int n = this.tree.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
            this.rateEvolution.sampleRate(nodeRef2);
            this.sampleSubtree(nodeRef2);
        }
    }

    void sampleSister(NodeRef nodeRef) {
        int n = this.tree.getChildCount(nodeRef);
        for (int i = 0; i < n; ++i) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, i);
            this.rateEvolution.sampleRate(nodeRef2);
        }
    }

    void sampleNode(NodeRef nodeRef) {
        int n = this.tree.getChildCount(nodeRef);
        if (n > 0) {
            int n2 = MathUtils.nextInt(n);
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, n2);
            this.rateEvolution.sampleRate(nodeRef2);
        }
    }

    void sampleOne(NodeRef nodeRef) {
        int n = this.tree.getChildCount(nodeRef);
        if (n > 0) {
            NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
            this.rateEvolution.sampleRate(nodeRef2);
        }
    }

    void cleanupOperation(double d, double d2) {
    }

    @Override
    public final String getOperatorName() {
        return "rateSample";
    }

    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public final String getPerformanceSuggestion() {
        return "No suggestions";
    }

    public String toString() {
        return "rateSampleOperator(";
    }
}

