/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Objects;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.model.ToStringHelper;

public abstract class ProductFeature
extends Feature {
    private Feature feature = null;
    private Number factor = null;

    public ProductFeature(PMMLEncoder encoder, Feature feature, Number factor) {
        super(encoder, FeatureUtil.getName(feature), feature.getDataType());
        this.setFeature(feature);
        this.setFactor(factor);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.getFeature());
        result = 31 * result + Objects.hashCode(this.getFactor());
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ProductFeature) {
            ProductFeature that = (ProductFeature)object;
            return super.equals(object) && Objects.equals(this.getFeature(), that.getFeature()) && Objects.equals(this.getFactor(), that.getFactor());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("feature", (Object)this.getFeature()).add("factor", (Object)this.getFactor());
    }

    public Feature getFeature() {
        return this.feature;
    }

    private void setFeature(Feature feature) {
        this.feature = Objects.requireNonNull(feature);
    }

    public Number getFactor() {
        return this.factor;
    }

    private void setFactor(Number factor) {
        this.factor = Objects.requireNonNull(factor);
    }
}

