/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.sys;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import lombok.Generated;
import standalone_spreadsheet.internal.io.text.InternalTextResource;
import standalone_spreadsheet.nbbrd.io.text.TextResource;

public final class EndOfProcessException
extends IOException {
    private final int exitValue;
    private final String errorMessage;

    public static EndOfProcessException of(Process process) throws IOException {
        return new EndOfProcessException(process.exitValue(), EndOfProcessException.readErrorStream(process));
    }

    private EndOfProcessException(int exitValue, String errorMessage) {
        super("Invalid exit value: " + exitValue + " " + errorMessage);
        this.exitValue = exitValue;
        this.errorMessage = errorMessage;
    }

    private static String readErrorStream(Process process) throws IOException {
        try (BufferedReader reader = TextResource.newBufferedReader(process.getErrorStream(), Charset.defaultCharset());){
            String string = InternalTextResource.copyByLineToString(reader, System.lineSeparator());
            return string;
        }
    }

    @Generated
    public int getExitValue() {
        return this.exitValue;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

