/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.IPredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.StateStorage;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateFilteringResults;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateUpdateInformation;
import jdplus.toolkit.base.core.ssf.multivariate.PredictionErrorsDecomposition;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class MultivariateFilteringInformation
implements IPredictionErrorDecomposition,
IMultivariateFilteringResults {
    private PredictionErrorsDecomposition predictionErrorsDecomposition;
    private MultivariateUpdateInformation[] infos;
    private StateStorage states;
    private static final int ALLOC = 32;

    public DataBlock a(int t) {
        return this.states.a(t);
    }

    public FastMatrix P(int t) {
        return this.states.P(t);
    }

    @Override
    public void open(IMultivariateSsf ssf, IMultivariateSsfData data) {
        this.infos = new MultivariateUpdateInformation[data.getObsCount()];
        this.predictionErrorsDecomposition = new PredictionErrorsDecomposition();
        this.states = StateStorage.full(StateInfo.Forecast);
        this.states.prepare(ssf.getStateDim(), 0, data.getObsCount());
    }

    @Override
    public void close() {
    }

    public int size() {
        return this.infos.length;
    }

    public MultivariateUpdateInformation get(int idx) {
        return this.infos[idx];
    }

    @Override
    public void save(int t, MultivariateUpdateInformation pe) {
        this.predictionErrorsDecomposition.save(t, pe);
        if (t >= this.infos.length) {
            MultivariateUpdateInformation[] tmp = new MultivariateUpdateInformation[t + 32];
            System.arraycopy(this.infos, 0, tmp, 0, this.infos.length);
            this.infos = tmp;
        }
        this.infos[t] = pe;
    }

    @Override
    public void save(int pos, State state, StateInfo info) {
        this.states.save(pos, state, info);
    }

    @Override
    public Likelihood likelihood(boolean scalingfactor) {
        return this.predictionErrorsDecomposition.likelihood(scalingfactor);
    }
}

