/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.HapsMarker;

public interface VcfEmission
extends HapsMarker {
    public int nSamples();

    public Samples samples();

    public boolean isRefData();

    public float gl(int var1, int var2, int var3);

    public boolean isPhased(int var1);

    @Override
    public int allele1(int var1);

    @Override
    public int allele2(int var1);

    @Override
    public int allele(int var1);

    public int nAlleles();

    public boolean storesNonMajorIndices();

    public int majorAllele();

    public int alleleCount(int var1);

    public int hapIndex(int var1, int var2);

    default public String toVcfRec() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.marker());
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("GT");
        int n = this.nSamples();
        for (int i = 0; i < n; ++i) {
            int n2 = this.allele1(i);
            int n3 = this.allele2(i);
            stringBuilder.append('\t');
            stringBuilder.append(n2 == -1 ? 46 : n2);
            stringBuilder.append(this.isPhased(i) ? (char)'|' : '/');
            stringBuilder.append(n3 == -1 ? 46 : n3);
        }
        return stringBuilder.toString();
    }
}

