/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.jolokia.discovery.AgentDetails;
import org.json.simple.JSONObject;

abstract class AbstractDiscoveryMessage {
    public static final int MAX_MSG_SIZE = 8972;
    private MessageType type;
    private AgentDetails agentDetails;

    AbstractDiscoveryMessage() {
    }

    protected final void setType(MessageType pType) {
        this.type = pType;
    }

    protected final void setAgentDetails(AgentDetails pAgentDetails) {
        this.agentDetails = pAgentDetails;
    }

    public boolean isQuery() {
        return this.type == MessageType.QUERY;
    }

    public boolean isResponse() {
        return this.type == MessageType.RESPONSE;
    }

    public byte[] getData() {
        byte[] ret;
        JSONObject respond = new JSONObject();
        respond.put((Object)Payload.TYPE.asKey(), (Object)this.type.toString().toLowerCase());
        if (this.agentDetails != null) {
            respond.putAll((Map)this.agentDetails.toJSONObject());
        }
        if ((ret = this.getBytes(respond.toJSONString())).length > 8972) {
            throw new IllegalArgumentException("Message to send is larger (" + ret.length + " bytes) than maximum size of " + 8972 + " bytes.");
        }
        return ret;
    }

    public AgentDetails getAgentDetails() {
        return this.agentDetails;
    }

    protected byte[] getBytes(String pRespond) {
        try {
            return pRespond.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return pRespond.getBytes();
        }
    }

    public String toString() {
        return "{type=" + (Object)((Object)this.type) + ", agentDetails=" + this.agentDetails + '}';
    }

    static enum MessageType {
        QUERY,
        RESPONSE;

    }

    public static enum Payload {
        TYPE,
        URL,
        SECURED,
        SERVER_VENDOR,
        SERVER_PRODUCT,
        SERVER_VERSION,
        AGENT_VERSION,
        AGENT_ID,
        AGENT_DESCRIPTION;


        String asKey() {
            return this.name().toLowerCase();
        }

        public static Payload fromKey(String pKey) {
            return Payload.valueOf(pKey.toUpperCase());
        }
    }
}

