/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive message to Apache Iggy streaming platform.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IggyEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Iggy component.
     */
    public interface IggyEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedIggyEndpointConsumerBuilder advanced() {
            return (AdvancedIggyEndpointConsumerBuilder) this;
        }
        /**
         * Whether to automatically create stream if it does not exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateStream the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder autoCreateStream(boolean autoCreateStream) {
            doSetProperty("autoCreateStream", autoCreateStream);
            return this;
        }
        /**
         * Whether to automatically create stream if it does not exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateStream the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder autoCreateStream(String autoCreateStream) {
            doSetProperty("autoCreateStream", autoCreateStream);
            return this;
        }
        /**
         * Whether to automatically create topic if it does not exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateTopic the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder autoCreateTopic(boolean autoCreateTopic) {
            doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }
        /**
         * Whether to automatically create topic if it does not exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateTopic the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder autoCreateTopic(String autoCreateTopic) {
            doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }
        /**
         * Polling strategy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TCP
         * Group: common
         * 
         * @param clientTransport the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder clientTransport(String clientTransport) {
            doSetProperty("clientTransport", clientTransport);
            return this;
        }
        /**
         * Compression algorithm for message payload.
         * 
         * The option is a:
         * <code>org.apache.iggy.topic.CompressionAlgorithm</code> type.
         * 
         * Default: None
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder compressionAlgorithm(org.apache.iggy.topic.CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * Compression algorithm for message payload.
         * 
         * The option will be converted to a
         * <code>org.apache.iggy.topic.CompressionAlgorithm</code> type.
         * 
         * Default: None
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder compressionAlgorithm(String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * Iggy server hostname or IP address.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: localhost
         * Group: common
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Maximum topic size in bytes (0 means unlimited).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxTopicSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder maxTopicSize(Long maxTopicSize) {
            doSetProperty("maxTopicSize", maxTopicSize);
            return this;
        }
        /**
         * Maximum topic size in bytes (0 means unlimited).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxTopicSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder maxTopicSize(String maxTopicSize) {
            doSetProperty("maxTopicSize", maxTopicSize);
            return this;
        }
        /**
         * Message expiry time in seconds (0 means no expiry).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param messageExpiry the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder messageExpiry(Long messageExpiry) {
            doSetProperty("messageExpiry", messageExpiry);
            return this;
        }
        /**
         * Message expiry time in seconds (0 means no expiry).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param messageExpiry the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder messageExpiry(String messageExpiry) {
            doSetProperty("messageExpiry", messageExpiry);
            return this;
        }
        /**
         * Number of partitions for the topic.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param partitionsCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder partitionsCount(Long partitionsCount) {
            doSetProperty("partitionsCount", partitionsCount);
            return this;
        }
        /**
         * Number of partitions for the topic.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param partitionsCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder partitionsCount(String partitionsCount) {
            doSetProperty("partitionsCount", partitionsCount);
            return this;
        }
        /**
         * Iggy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Iggy server port number.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8090
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Iggy server port number.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8090
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Replication factor for the topic.
         * 
         * The option is a: <code>java.lang.Short</code> type.
         * 
         * Group: common
         * 
         * @param replicationFactor the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder replicationFactor(Short replicationFactor) {
            doSetProperty("replicationFactor", replicationFactor);
            return this;
        }
        /**
         * Replication factor for the topic.
         * 
         * The option will be converted to a <code>java.lang.Short</code> type.
         * 
         * Group: common
         * 
         * @param replicationFactor the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder replicationFactor(String replicationFactor) {
            doSetProperty("replicationFactor", replicationFactor);
            return this;
        }
        /**
         * Stream identifier.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param streamId the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder streamId(Long streamId) {
            doSetProperty("streamId", streamId);
            return this;
        }
        /**
         * Stream identifier.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param streamId the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder streamId(String streamId) {
            doSetProperty("streamId", streamId);
            return this;
        }
        /**
         * Stream name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param streamName the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder streamName(String streamName) {
            doSetProperty("streamName", streamName);
            return this;
        }
        /**
         * Controls message acknowledgment behavior. When true, messages are
         * automatically marked as processed after consumption. When false,
         * enables manual offset management and allows setting a custom starting
         * offset position.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCommit the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder autoCommit(boolean autoCommit) {
            doSetProperty("autoCommit", autoCommit);
            return this;
        }
        /**
         * Controls message acknowledgment behavior. When true, messages are
         * automatically marked as processed after consumption. When false,
         * enables manual offset management and allows setting a custom starting
         * offset position.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoCommit the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder autoCommit(String autoCommit) {
            doSetProperty("autoCommit", autoCommit);
            return this;
        }
        /**
         * The name of the consumer group.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param consumerGroupName the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder consumerGroupName(String consumerGroupName) {
            doSetProperty("consumerGroupName", consumerGroupName);
            return this;
        }
        /**
         * Camel Iggy consumers count.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumersCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder consumersCount(int consumersCount) {
            doSetProperty("consumersCount", consumersCount);
            return this;
        }
        /**
         * Camel Iggy consumers count.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param consumersCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder consumersCount(String consumersCount) {
            doSetProperty("consumersCount", consumersCount);
            return this;
        }
        /**
         * The consumer partition id.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         * 
         * @param partitionId the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder partitionId(Long partitionId) {
            doSetProperty("partitionId", partitionId);
            return this;
        }
        /**
         * The consumer partition id.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         * 
         * @param partitionId the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder partitionId(String partitionId) {
            doSetProperty("partitionId", partitionId);
            return this;
        }
        /**
         * The consumer poll batch size.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param pollBatchSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder pollBatchSize(Long pollBatchSize) {
            doSetProperty("pollBatchSize", pollBatchSize);
            return this;
        }
        /**
         * The consumer poll batch size.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param pollBatchSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder pollBatchSize(String pollBatchSize) {
            doSetProperty("pollBatchSize", pollBatchSize);
            return this;
        }
        /**
         * Polling strategy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: next
         * Group: consumer
         * 
         * @param pollingStrategy the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder pollingStrategy(String pollingStrategy) {
            doSetProperty("pollingStrategy", pollingStrategy);
            return this;
        }
        /**
         * Camel Iggy shutdown timeout.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder shutdownTimeout(int shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Camel Iggy shutdown timeout.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param shutdownTimeout the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder shutdownTimeout(String shutdownTimeout) {
            doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }
        /**
         * Defines the initial message offset position when autoCommit is
         * disabled. Use 0 to start from the beginning of the stream, or specify
         * a custom offset to resume from a particular point.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: consumer
         * 
         * @param startingOffset the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder startingOffset(Long startingOffset) {
            doSetProperty("startingOffset", startingOffset);
            return this;
        }
        /**
         * Defines the initial message offset position when autoCommit is
         * disabled. Use 0 to start from the beginning of the stream, or specify
         * a custom offset to resume from a particular point.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: consumer
         * 
         * @param startingOffset the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder startingOffset(String startingOffset) {
            doSetProperty("startingOffset", startingOffset);
            return this;
        }
        /**
         * Iggy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default IggyEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Iggy component.
     */
    public interface AdvancedIggyEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default IggyEndpointConsumerBuilder basic() {
            return (IggyEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Iggy component.
     */
    public interface IggyEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedIggyEndpointProducerBuilder advanced() {
            return (AdvancedIggyEndpointProducerBuilder) this;
        }

        /**
         * Whether to automatically create stream if it does not exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateStream the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder autoCreateStream(boolean autoCreateStream) {
            doSetProperty("autoCreateStream", autoCreateStream);
            return this;
        }
        /**
         * Whether to automatically create stream if it does not exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateStream the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder autoCreateStream(String autoCreateStream) {
            doSetProperty("autoCreateStream", autoCreateStream);
            return this;
        }
        /**
         * Whether to automatically create topic if it does not exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateTopic the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder autoCreateTopic(boolean autoCreateTopic) {
            doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }
        /**
         * Whether to automatically create topic if it does not exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateTopic the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder autoCreateTopic(String autoCreateTopic) {
            doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }
        /**
         * Polling strategy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TCP
         * Group: common
         * 
         * @param clientTransport the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder clientTransport(String clientTransport) {
            doSetProperty("clientTransport", clientTransport);
            return this;
        }
        /**
         * Compression algorithm for message payload.
         * 
         * The option is a:
         * <code>org.apache.iggy.topic.CompressionAlgorithm</code> type.
         * 
         * Default: None
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder compressionAlgorithm(org.apache.iggy.topic.CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * Compression algorithm for message payload.
         * 
         * The option will be converted to a
         * <code>org.apache.iggy.topic.CompressionAlgorithm</code> type.
         * 
         * Default: None
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder compressionAlgorithm(String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * Iggy server hostname or IP address.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: localhost
         * Group: common
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Maximum topic size in bytes (0 means unlimited).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxTopicSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder maxTopicSize(Long maxTopicSize) {
            doSetProperty("maxTopicSize", maxTopicSize);
            return this;
        }
        /**
         * Maximum topic size in bytes (0 means unlimited).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxTopicSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder maxTopicSize(String maxTopicSize) {
            doSetProperty("maxTopicSize", maxTopicSize);
            return this;
        }
        /**
         * Message expiry time in seconds (0 means no expiry).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param messageExpiry the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder messageExpiry(Long messageExpiry) {
            doSetProperty("messageExpiry", messageExpiry);
            return this;
        }
        /**
         * Message expiry time in seconds (0 means no expiry).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param messageExpiry the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder messageExpiry(String messageExpiry) {
            doSetProperty("messageExpiry", messageExpiry);
            return this;
        }
        /**
         * Number of partitions for the topic.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param partitionsCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder partitionsCount(Long partitionsCount) {
            doSetProperty("partitionsCount", partitionsCount);
            return this;
        }
        /**
         * Number of partitions for the topic.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param partitionsCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder partitionsCount(String partitionsCount) {
            doSetProperty("partitionsCount", partitionsCount);
            return this;
        }
        /**
         * Iggy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Iggy server port number.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8090
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Iggy server port number.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8090
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Replication factor for the topic.
         * 
         * The option is a: <code>java.lang.Short</code> type.
         * 
         * Group: common
         * 
         * @param replicationFactor the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder replicationFactor(Short replicationFactor) {
            doSetProperty("replicationFactor", replicationFactor);
            return this;
        }
        /**
         * Replication factor for the topic.
         * 
         * The option will be converted to a <code>java.lang.Short</code> type.
         * 
         * Group: common
         * 
         * @param replicationFactor the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder replicationFactor(String replicationFactor) {
            doSetProperty("replicationFactor", replicationFactor);
            return this;
        }
        /**
         * Stream identifier.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param streamId the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder streamId(Long streamId) {
            doSetProperty("streamId", streamId);
            return this;
        }
        /**
         * Stream identifier.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param streamId the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder streamId(String streamId) {
            doSetProperty("streamId", streamId);
            return this;
        }
        /**
         * Stream name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param streamName the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder streamName(String streamName) {
            doSetProperty("streamName", streamName);
            return this;
        }
        /**
         * Partitioning strategy for message distribution.
         * 
         * The option is a: <code>org.apache.iggy.message.Partitioning</code>
         * type.
         * 
         * Default: balanced
         * Group: producer
         * 
         * @param partitioning the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder partitioning(org.apache.iggy.message.Partitioning partitioning) {
            doSetProperty("partitioning", partitioning);
            return this;
        }
        /**
         * Partitioning strategy for message distribution.
         * 
         * The option will be converted to a
         * <code>org.apache.iggy.message.Partitioning</code> type.
         * 
         * Default: balanced
         * Group: producer
         * 
         * @param partitioning the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder partitioning(String partitioning) {
            doSetProperty("partitioning", partitioning);
            return this;
        }
        /**
         * Iggy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default IggyEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Iggy component.
     */
    public interface AdvancedIggyEndpointProducerBuilder extends EndpointProducerBuilder {
        default IggyEndpointProducerBuilder basic() {
            return (IggyEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIggyEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Iggy component.
     */
    public interface IggyEndpointBuilder
            extends
                IggyEndpointConsumerBuilder,
                IggyEndpointProducerBuilder {
        default AdvancedIggyEndpointBuilder advanced() {
            return (AdvancedIggyEndpointBuilder) this;
        }

        /**
         * Whether to automatically create stream if it does not exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateStream the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder autoCreateStream(boolean autoCreateStream) {
            doSetProperty("autoCreateStream", autoCreateStream);
            return this;
        }
        /**
         * Whether to automatically create stream if it does not exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateStream the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder autoCreateStream(String autoCreateStream) {
            doSetProperty("autoCreateStream", autoCreateStream);
            return this;
        }
        /**
         * Whether to automatically create topic if it does not exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateTopic the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder autoCreateTopic(boolean autoCreateTopic) {
            doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }
        /**
         * Whether to automatically create topic if it does not exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateTopic the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder autoCreateTopic(String autoCreateTopic) {
            doSetProperty("autoCreateTopic", autoCreateTopic);
            return this;
        }
        /**
         * Polling strategy.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: TCP
         * Group: common
         * 
         * @param clientTransport the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder clientTransport(String clientTransport) {
            doSetProperty("clientTransport", clientTransport);
            return this;
        }
        /**
         * Compression algorithm for message payload.
         * 
         * The option is a:
         * <code>org.apache.iggy.topic.CompressionAlgorithm</code> type.
         * 
         * Default: None
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder compressionAlgorithm(org.apache.iggy.topic.CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * Compression algorithm for message payload.
         * 
         * The option will be converted to a
         * <code>org.apache.iggy.topic.CompressionAlgorithm</code> type.
         * 
         * Default: None
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder compressionAlgorithm(String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * Iggy server hostname or IP address.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: localhost
         * Group: common
         * 
         * @param host the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Maximum topic size in bytes (0 means unlimited).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxTopicSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder maxTopicSize(Long maxTopicSize) {
            doSetProperty("maxTopicSize", maxTopicSize);
            return this;
        }
        /**
         * Maximum topic size in bytes (0 means unlimited).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxTopicSize the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder maxTopicSize(String maxTopicSize) {
            doSetProperty("maxTopicSize", maxTopicSize);
            return this;
        }
        /**
         * Message expiry time in seconds (0 means no expiry).
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param messageExpiry the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder messageExpiry(Long messageExpiry) {
            doSetProperty("messageExpiry", messageExpiry);
            return this;
        }
        /**
         * Message expiry time in seconds (0 means no expiry).
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param messageExpiry the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder messageExpiry(String messageExpiry) {
            doSetProperty("messageExpiry", messageExpiry);
            return this;
        }
        /**
         * Number of partitions for the topic.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param partitionsCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder partitionsCount(Long partitionsCount) {
            doSetProperty("partitionsCount", partitionsCount);
            return this;
        }
        /**
         * Number of partitions for the topic.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Default: 1
         * Group: common
         * 
         * @param partitionsCount the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder partitionsCount(String partitionsCount) {
            doSetProperty("partitionsCount", partitionsCount);
            return this;
        }
        /**
         * Iggy password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Iggy server port number.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 8090
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder port(int port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Iggy server port number.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 8090
         * Group: common
         * 
         * @param port the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder port(String port) {
            doSetProperty("port", port);
            return this;
        }
        /**
         * Replication factor for the topic.
         * 
         * The option is a: <code>java.lang.Short</code> type.
         * 
         * Group: common
         * 
         * @param replicationFactor the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder replicationFactor(Short replicationFactor) {
            doSetProperty("replicationFactor", replicationFactor);
            return this;
        }
        /**
         * Replication factor for the topic.
         * 
         * The option will be converted to a <code>java.lang.Short</code> type.
         * 
         * Group: common
         * 
         * @param replicationFactor the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder replicationFactor(String replicationFactor) {
            doSetProperty("replicationFactor", replicationFactor);
            return this;
        }
        /**
         * Stream identifier.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param streamId the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder streamId(Long streamId) {
            doSetProperty("streamId", streamId);
            return this;
        }
        /**
         * Stream identifier.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         * 
         * @param streamId the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder streamId(String streamId) {
            doSetProperty("streamId", streamId);
            return this;
        }
        /**
         * Stream name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param streamName the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder streamName(String streamName) {
            doSetProperty("streamName", streamName);
            return this;
        }
        /**
         * Iggy username.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default IggyEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Iggy component.
     */
    public interface AdvancedIggyEndpointBuilder
            extends
                AdvancedIggyEndpointConsumerBuilder,
                AdvancedIggyEndpointProducerBuilder {
        default IggyEndpointBuilder basic() {
            return (IggyEndpointBuilder) this;
        }

    }

    public interface IggyBuilders {
        /**
         * Iggy (camel-iggy)
         * Send and receive message to Apache Iggy streaming platform.
         * 
         * Category: messaging
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-iggy
         * 
         * Syntax: <code>iggy:topicName</code>
         * 
         * Path parameter: topicName (required)
         * Name of the topic
         * 
         * @param path topicName
         * @return the dsl builder
         */
        default IggyEndpointBuilder iggy(String path) {
            return IggyEndpointBuilderFactory.endpointBuilder("iggy", path);
        }
        /**
         * Iggy (camel-iggy)
         * Send and receive message to Apache Iggy streaming platform.
         * 
         * Category: messaging
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-iggy
         * 
         * Syntax: <code>iggy:topicName</code>
         * 
         * Path parameter: topicName (required)
         * Name of the topic
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path topicName
         * @return the dsl builder
         */
        default IggyEndpointBuilder iggy(String componentName, String path) {
            return IggyEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    static IggyEndpointBuilder endpointBuilder(String componentName, String path) {
        class IggyEndpointBuilderImpl extends AbstractEndpointBuilder implements IggyEndpointBuilder, AdvancedIggyEndpointBuilder {
            public IggyEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new IggyEndpointBuilderImpl(path);
    }
}