/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractMapIteratorTest<K, V>
extends AbstractIteratorTest<K> {
    public V[] addSetValues() {
        return new Object[]{"A", "B"};
    }

    public abstract Map<K, V> getConfirmedMap();

    public abstract Map<K, V> getMap();

    public boolean isGetStructuralModify() {
        return false;
    }

    public abstract MapIterator<K, V> makeEmptyIterator();

    public abstract MapIterator<K, V> makeObject();

    public boolean supportsSetValue() {
        return true;
    }

    @Test
    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        MapIterator it = this.makeEmptyIterator();
        Assertions.assertFalse((boolean)it.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> it.next());
        Assertions.assertThrows(IllegalStateException.class, () -> it.getKey());
        Assertions.assertThrows(IllegalStateException.class, () -> it.getValue());
        if (!this.supportsSetValue()) {
            try {
                it.setValue(this.addSetValues()[0]);
                Assertions.fail();
            }
            catch (IllegalStateException | UnsupportedOperationException runtimeException) {}
        } else {
            Assertions.assertThrows(IllegalStateException.class, () -> it.setValue(this.addSetValues()[0]));
        }
    }

    @Test
    public void testFullMapIterator() {
        if (!this.supportsFullIterator()) {
            return;
        }
        MapIterator<K, V> it = this.makeObject();
        Map<K, V> map = this.getMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasNext());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            Object key = it.next();
            Assertions.assertSame((Object)key, (Object)it.getKey(), (String)"it.next() should equals getKey()");
            Assertions.assertTrue((boolean)map.containsKey(key), (String)"Key must be in map");
            Assertions.assertTrue((boolean)set.add(key), (String)"Key must be unique");
            Object value = it.getValue();
            if (!this.isGetStructuralModify()) {
                Assertions.assertSame(map.get(key), (Object)value, (String)"Value must be mapped to key");
            }
            Assertions.assertTrue((boolean)map.containsValue(value), (String)"Value must be in map");
            this.verify();
        }
    }

    @Test
    public void testMapIteratorRemoveGetKey() {
        if (!this.supportsRemove()) {
            return;
        }
        MapIterator it = this.makeObject();
        Map<K, V> confirmed = this.getConfirmedMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Object key = it.next();
        it.remove();
        confirmed.remove(key);
        this.verify();
        Assertions.assertThrows(IllegalStateException.class, () -> it.getKey());
        this.verify();
    }

    @Test
    public void testMapIteratorRemoveGetValue() {
        if (!this.supportsRemove()) {
            return;
        }
        MapIterator it = this.makeObject();
        Map<K, V> confirmed = this.getConfirmedMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Object key = it.next();
        it.remove();
        confirmed.remove(key);
        this.verify();
        Assertions.assertThrows(IllegalStateException.class, () -> it.getValue());
        this.verify();
    }

    @Test
    public void testMapIteratorSet() {
        if (!this.supportsFullIterator()) {
            return;
        }
        Object newValue = this.addSetValues()[0];
        V newValue2 = this.addSetValues().length == 1 ? this.addSetValues()[0] : this.addSetValues()[1];
        MapIterator it = this.makeObject();
        Map<K, V> map = this.getMap();
        Map<Object, V> confirmed = this.getConfirmedMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Object key = it.next();
        Object value = it.getValue();
        if (!this.supportsSetValue()) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> it.setValue(newValue));
            return;
        }
        Object old = it.setValue(newValue);
        confirmed.put(key, newValue);
        Assertions.assertSame((Object)key, (Object)it.getKey(), (String)"Key must not change after setValue");
        Assertions.assertSame(newValue, (Object)it.getValue(), (String)"Value must be changed after setValue");
        Assertions.assertSame((Object)value, (Object)old, (String)"setValue must return old value");
        Assertions.assertTrue((boolean)map.containsKey(key), (String)"Map must contain key");
        Assertions.assertEquals((Object)confirmed.containsValue(old), (Object)map.containsValue(old), (String)"Map must not contain old value");
        Assertions.assertTrue((boolean)map.containsValue(newValue), (String)"Map must contain new value");
        this.verify();
        it.setValue(newValue);
        confirmed.put(key, newValue);
        Assertions.assertSame((Object)key, (Object)it.getKey(), (String)"Key must not change after setValue");
        Assertions.assertSame(newValue, (Object)it.getValue(), (String)"Value must be changed after setValue");
        this.verify();
        it.setValue(newValue2);
        confirmed.put(key, newValue2);
        Assertions.assertSame((Object)key, (Object)it.getKey(), (String)"Key must not change after setValue");
        Assertions.assertSame(newValue2, (Object)it.getValue(), (String)"Value must be changed after setValue");
        this.verify();
    }

    @Test
    public void testMapIteratorSetRemoveSet() {
        if (!this.supportsSetValue() || !this.supportsRemove()) {
            return;
        }
        Object newValue = this.addSetValues()[0];
        MapIterator it = this.makeObject();
        Map<K, V> confirmed = this.getConfirmedMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Object key = it.next();
        it.setValue(newValue);
        it.remove();
        confirmed.remove(key);
        this.verify();
        Assertions.assertThrows(IllegalStateException.class, () -> it.setValue(newValue));
        this.verify();
    }

    @Override
    @Test
    public void testRemove() {
        MapIterator it = this.makeObject();
        Map<K, V> map = this.getMap();
        Map<K, V> confirmed = this.getConfirmedMap();
        Assertions.assertTrue((boolean)it.hasNext());
        Object key = it.next();
        if (!this.supportsRemove()) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> it.remove());
            return;
        }
        it.remove();
        confirmed.remove(key);
        Assertions.assertFalse((boolean)map.containsKey(key));
        this.verify();
        Assertions.assertThrows(NoSuchElementException.class, () -> it.remove(), (String)"Full iterators must have at least one element");
        this.verify();
    }
}

