/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.exif.AbstractExifTest;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class GpsTest
extends AbstractExifTest {
    public static Stream<File> data() throws Exception {
        return GpsTest.getImagesWithExifData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(File imageFile) throws Exception {
        if (imageFile.getParentFile().getName().toLowerCase().equals("@broken")) {
            return;
        }
        JpegImageMetadata metadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
        if (null == metadata) {
            return;
        }
        TiffImageMetadata exifMetadata = metadata.getExif();
        if (null == exifMetadata) {
            return;
        }
        TiffImageMetadata.GpsInfo gpsInfo = exifMetadata.getGpsInfo();
        if (null == gpsInfo) {
            return;
        }
        Debug.debug((String)("imageFile " + imageFile));
        Debug.debug((String)("gpsInfo " + gpsInfo));
        Debug.debug((String)("gpsInfo longitude as degrees east " + gpsInfo.getLongitudeAsDegreesEast()));
        Debug.debug((String)("gpsInfo latitude as degrees north " + gpsInfo.getLatitudeAsDegreesNorth()));
        Debug.debug();
    }

    @Test
    public void testReadMetadata() throws Exception {
        File imageFile = new File(GpsTest.class.getResource("/images/jpeg/exif/2024-04-30_G012.JPG").getFile());
        JpegImageMetadata jpegMetadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
        TiffField gpsHPosErrorField = jpegMetadata.findExifValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_HOR_POSITIONING_ERROR);
        RationalNumber gpsHPosError = (RationalNumber)gpsHPosErrorField.getValue();
        Assertions.assertEquals((double)0.014, (double)gpsHPosError.doubleValue());
    }
}

