/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.simple;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.Test;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.simple.CustomConfigTestCase;
import org.apache.commons.logging.simple.DecoratedSimpleLog;

public class DateTimeCustomConfigTestCase
extends CustomConfigTestCase {
    public static Test suite() throws Exception {
        Class<DateTimeCustomConfigTestCase> thisClass = DateTimeCustomConfigTestCase.class;
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", Test.class.getClassLoader());
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    @Override
    protected void checkDecoratedDateTime() {
        DateTimeCustomConfigTestCase.assertEquals((String)"Expected date format to be set", (String)"dd.mm.yyyy", (String)((DecoratedSimpleLog)this.log).getDateTimeFormat());
        Date now = new Date();
        DateFormat formatter = ((DecoratedSimpleLog)this.log).getDateTimeFormatter();
        SimpleDateFormat sampleFormatter = new SimpleDateFormat("dd.mm.yyyy");
        DateTimeCustomConfigTestCase.assertEquals((String)"Date should be formatters to pattern dd.mm.yyyy", (String)sampleFormatter.format(now), (String)formatter.format(now));
    }

    @Override
    protected void checkShowDateTime() {
        DateTimeCustomConfigTestCase.assertTrue((boolean)((DecoratedSimpleLog)this.log).getShowDateTime());
    }

    @Override
    public void setProperties() {
        super.setProperties();
        System.setProperty("org.apache.commons.logging.simplelog.dateTimeFormat", "dd.mm.yyyy");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }
}

