/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.sts.claims.ClaimsHandler;
import org.apache.cxf.sts.claims.ClaimsParameters;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;

public class StaticEndpointClaimsHandler
implements ClaimsHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticEndpointClaimsHandler.class);
    private Map<String, Map<String, String>> endpointClaimsMap;
    private List<String> supportedClaims;

    public void setEndpointClaims(Map<String, Map<String, String>> userClaims) {
        this.endpointClaimsMap = userClaims;
    }

    public Map<String, Map<String, String>> getEndpointClaims() {
        return this.endpointClaimsMap;
    }

    public void setSupportedClaims(List<String> supportedClaims) {
        this.supportedClaims = supportedClaims;
    }

    @Override
    public List<String> getSupportedClaimTypes() {
        return Collections.unmodifiableList(this.supportedClaims);
    }

    @Override
    public ProcessedClaimCollection retrieveClaimValues(ClaimCollection claims, ClaimsParameters parameters) {
        ProcessedClaimCollection claimsColl = new ProcessedClaimCollection();
        String appliesTo = parameters.getAppliesToAddress();
        if (appliesTo == null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("AppliesTo not provided in RST. " + StaticEndpointClaimsHandler.class.getName() + " ignored");
            }
            return claimsColl;
        }
        Map<String, String> endpointClaims = this.getEndpointClaims().get(appliesTo);
        if (endpointClaims == null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer(StaticEndpointClaimsHandler.class.getName() + " doesn't define claims for endpoint '" + appliesTo + "'");
            }
            return claimsColl;
        }
        for (Claim claim : claims) {
            if (endpointClaims.keySet().contains(claim.getClaimType())) {
                ProcessedClaim c = new ProcessedClaim();
                c.setClaimType(claim.getClaimType());
                c.setPrincipal(parameters.getPrincipal());
                c.addValue(endpointClaims.get(claim.getClaimType()));
                claimsColl.add(c);
                continue;
            }
            if (!LOG.isLoggable(Level.FINER)) continue;
            LOG.finer("Unsupported claim: " + claim.getClaimType());
        }
        return claimsColl;
    }
}

