/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.util;

import jakarta.enterprise.inject.Vetoed;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.deltaspike.core.util.ClassUtils;

@Vetoed
public abstract class PropertyFileUtils {
    private PropertyFileUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Enumeration<URL> resolvePropertyFiles(String propertyFileName) throws IOException {
        File file;
        if (propertyFileName != null && (propertyFileName.contains("://") || propertyFileName.startsWith("file:"))) {
            Vector<URL> propertyFileUrls = new Vector<URL>();
            URL url = new URL(propertyFileName);
            if (propertyFileName.startsWith("file:")) {
                try {
                    File file2 = new File(url.toURI());
                    if (!file2.exists()) return propertyFileUrls.elements();
                    propertyFileUrls.add(url);
                    return propertyFileUrls.elements();
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException("Property file URL is malformed", e);
                }
            } else {
                propertyFileUrls.add(url);
            }
            return propertyFileUrls.elements();
        }
        if (propertyFileName != null && (file = new File(propertyFileName)).exists()) {
            return Collections.enumeration(Collections.singleton(file.toURI().toURL()));
        }
        ClassLoader cl = ClassUtils.getClassLoader(null);
        Enumeration<URL> propertyFileUrls = cl.getResources(propertyFileName);
        if (propertyFileUrls.hasMoreElements()) return propertyFileUrls;
        cl = PropertyFileUtils.class.getClassLoader();
        return cl.getResources(propertyFileName);
    }

    public static Properties loadProperties(URL url) {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            if (inputStream != null) {
                props.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public static ResourceBundle getResourceBundle(String bundleName) {
        return PropertyFileUtils.getResourceBundle(bundleName, Locale.getDefault());
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale, ClassUtils.getClassLoader(null));
    }
}

