/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.normaliser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.normaliser.Normaliser;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserData;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserField;

@Transform(id="Normaliser", name="i18n::Normaliser.Name", description="i18n::Normaliser.Description", image="normaliser.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::NormaliserMeta.keyword"}, documentationUrl="/pipeline/transforms/rownormaliser.html")
public class NormaliserMeta
extends BaseTransformMeta<Normaliser, NormaliserData> {
    private static final Class<?> PKG = NormaliserMeta.class;
    @HopMetadataProperty(key="typefield", injectionKey="TYPEFIELD", injectionKeyDescription="NormaliserMeta.Injection.TYPEFIELD")
    private String typeField;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="NormaliserMeta.Injection.FIELDS")
    private List<NormaliserField> normaliserFields = new ArrayList<NormaliserField>();

    public NormaliserMeta() {
    }

    public NormaliserMeta(NormaliserMeta meta) {
        this();
        for (NormaliserField field : meta.normaliserFields) {
            this.normaliserFields.add(new NormaliserField(field));
        }
    }

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public List<NormaliserField> getNormaliserFields() {
        return this.normaliserFields;
    }

    public void setNormaliserFields(List<NormaliserField> normaliserFields) {
        this.normaliserFields = normaliserFields;
    }

    public Set<String> getFieldNames() {
        HashSet<String> fieldNames = new HashSet<String>();
        for (NormaliserField field : this.normaliserFields) {
            if (field.getName() == null) continue;
            fieldNames.add(field.getName().toLowerCase());
        }
        return fieldNames;
    }

    public Object clone() {
        return new NormaliserMeta(this);
    }

    public void setDefault() {
        this.typeField = "typefield";
        this.normaliserFields = new ArrayList<NormaliserField>();
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ArrayList<String> normOcc = new ArrayList<String>();
        ArrayList<String> fieldOcc = new ArrayList<String>();
        int maxlen = 0;
        for (NormaliserField field : this.normaliserFields) {
            if (!normOcc.contains(field.getNorm())) {
                normOcc.add(field.getNorm());
                fieldOcc.add(field.getName());
            }
            if (field.getValue().length() <= maxlen) continue;
            maxlen = field.getValue().length();
        }
        ValueMetaString typefieldValue = new ValueMetaString(this.typeField);
        typefieldValue.setOrigin(name);
        typefieldValue.setLength(maxlen);
        row.addValueMeta((IValueMeta)typefieldValue);
        for (int i = 0; i < normOcc.size(); ++i) {
            String normname = (String)normOcc.get(i);
            String fieldname = (String)fieldOcc.get(i);
            IValueMeta v = row.searchValueMeta(fieldname);
            if (v == null) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"NormaliserMeta.Exception.UnableToFindField", (String[])new String[]{fieldname}));
            }
            v = v.clone();
            v.setName(normname);
            v.setOrigin(name);
            row.addValueMeta(v);
        }
        for (NormaliserField field : this.normaliserFields) {
            int idx = row.indexOfValue(field.getName());
            if (idx < 0) continue;
            row.removeValueMeta(idx);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        Object errorMessage = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            boolean first = true;
            errorMessage = "";
            boolean errorFound = false;
            for (NormaliserField field : this.normaliserFields) {
                IValueMeta valueMeta = prev.searchValueMeta(field.getName());
                if (valueMeta != null) continue;
                if (first) {
                    first = false;
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR;
                }
                errorFound = true;
                errorMessage = (String)errorMessage + "\t\t" + field.getName() + Const.CR;
            }
            cr = errorFound ? new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NormaliserMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

