/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.PutCompositeAlarmRequest;
import com.amazonaws.services.cloudwatch.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutCompositeAlarmRequestMarshaller
implements Marshaller<Request<PutCompositeAlarmRequest>, PutCompositeAlarmRequest> {
    public Request<PutCompositeAlarmRequest> marshall(PutCompositeAlarmRequest putCompositeAlarmRequest) {
        if (putCompositeAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putCompositeAlarmRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutCompositeAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putCompositeAlarmRequest.getActionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean((Boolean)putCompositeAlarmRequest.getActionsEnabled()));
        }
        if (!putCompositeAlarmRequest.getAlarmActions().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getAlarmActions()).isAutoConstruct()) {
            SdkInternalList alarmActionsList = (SdkInternalList)putCompositeAlarmRequest.getAlarmActions();
            int alarmActionsListIndex = 1;
            for (String alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringUtils.fromString((String)alarmActionsListValue));
                }
                ++alarmActionsListIndex;
            }
        }
        if (putCompositeAlarmRequest.getAlarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString((String)putCompositeAlarmRequest.getAlarmDescription()));
        }
        if (putCompositeAlarmRequest.getAlarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)putCompositeAlarmRequest.getAlarmName()));
        }
        if (putCompositeAlarmRequest.getAlarmRule() != null) {
            request.addParameter("AlarmRule", StringUtils.fromString((String)putCompositeAlarmRequest.getAlarmRule()));
        }
        if (!putCompositeAlarmRequest.getInsufficientDataActions().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getInsufficientDataActions()).isAutoConstruct()) {
            SdkInternalList insufficientDataActionsList = (SdkInternalList)putCompositeAlarmRequest.getInsufficientDataActions();
            int insufficientDataActionsListIndex = 1;
            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex, StringUtils.fromString((String)insufficientDataActionsListValue));
                }
                ++insufficientDataActionsListIndex;
            }
        }
        if (!putCompositeAlarmRequest.getOKActions().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getOKActions()).isAutoConstruct()) {
            SdkInternalList oKActionsList = (SdkInternalList)putCompositeAlarmRequest.getOKActions();
            int oKActionsListIndex = 1;
            for (String oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString((String)oKActionsListValue));
                }
                ++oKActionsListIndex;
            }
        }
        if (!putCompositeAlarmRequest.getTags().isEmpty() || !((SdkInternalList)putCompositeAlarmRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)putCompositeAlarmRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

