/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryParserMetricsHolder;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryDescriptor;
import org.apache.ignite.internal.processors.query.h2.QueryParameters;
import org.apache.ignite.internal.processors.query.h2.QueryParserCacheEntry;
import org.apache.ignite.internal.processors.query.h2.QueryParserResult;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultCommand;
import org.apache.ignite.internal.processors.query.h2.QueryParserResultDml;
import org.apache.ignite.internal.processors.query.h2.dml.DmlAstUtils;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlanBuilder;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.sql.SqlParseException;
import org.apache.ignite.internal.sql.SqlParser;
import org.apache.ignite.internal.sql.SqlStrictParseException;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Prepared;
import org.jetbrains.annotations.Nullable;

public class QueryParser {
    private static final int CACHE_SIZE = 1024;
    private static final Pattern INTERNAL_CMD_RE = Pattern.compile("^(create|drop)\\s+index|^analyze\\s|^refresh\\s+statistics|^drop\\s+statistics|^alter\\s+table|^copy|^set|^begin|^start|^commit|^rollback|^(create|alter|drop)\\s+user|^(create|create\\s+or\\s+replace|drop)\\s+view|^kill\\s+(query|scan|continuous|compute|service|transaction|client)|show|help|grant|revoke", 2);
    private final IgniteH2Indexing idx;
    private final ConnectionManager connMgr;
    private final IgniteLogger log;
    private final QueryParserMetricsHolder metricsHolder;
    private final Predicate<SqlCommand> nativeCmdPredicate;
    private final boolean forceFillAbsentPKsWithDefaults;
    private volatile GridBoundedConcurrentLinkedHashMap<QueryDescriptor, QueryParserCacheEntry> cache = new GridBoundedConcurrentLinkedHashMap(1024);

    public QueryParser(IgniteH2Indexing idx, ConnectionManager connMgr, Predicate<SqlCommand> nativeCmdPredicate) {
        this.idx = idx;
        this.connMgr = connMgr;
        this.nativeCmdPredicate = nativeCmdPredicate;
        this.log = idx.kernalContext().log(QueryParser.class);
        this.metricsHolder = new QueryParserMetricsHolder(idx.kernalContext().metric());
        this.forceFillAbsentPKsWithDefaults = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_FILL_ABSENT_PK_WITH_DEFAULTS", (boolean)false);
    }

    public QueryParserResult parse(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.idx.kernalContext().tracing().create(SpanType.SQL_QRY_PARSE, MTC.span()));){
            QueryParserResult res = this.parse0(schemaName, qry, remainingAllowed);
            QueryParser.checkQueryType(qry, res.isSelect());
            QueryParserResult queryParserResult = res;
            return queryParserResult;
        }
    }

    public QueryParameters queryParameters(SqlFieldsQuery qry) {
        int timeout;
        boolean autoCommit = true;
        List batchedArgs = null;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            autoCommit = qry0.isAutoCommit();
            batchedArgs = qry0.batchedArguments();
        }
        if ((timeout = qry.getTimeout()) < 0) {
            timeout = this.idx.distributedConfiguration().defaultQueryTimeout();
        }
        return new QueryParameters(qry.getArgs(), qry.getPartitions(), timeout, qry.isLazy(), qry.getPageSize(), null, autoCommit, batchedArgs, qry.getUpdateBatchSize());
    }

    private QueryParserResult parse0(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        QueryDescriptor qryDesc = QueryParser.queryDescriptor(schemaName, qry);
        QueryParserCacheEntry cached = (QueryParserCacheEntry)this.cache.get((Object)qryDesc);
        if (cached != null) {
            this.metricsHolder.countCacheHit();
            MTC.span().addTag("sql.parser.cache.hit", () -> "true");
            return new QueryParserResult(qryDesc, this.queryParameters(qry), null, cached.parametersMeta(), cached.select(), cached.dml(), cached.command());
        }
        this.metricsHolder.countCacheMiss();
        MTC.span().addTag("sql.parser.cache.hit", () -> "false");
        QueryParserResult parseRes = this.parseNative(schemaName, qry, remainingAllowed);
        if (parseRes == null) {
            parseRes = this.parseH2(schemaName, qry, qryDesc.batched(), remainingAllowed);
        }
        if (parseRes.remainingQuery() == null) {
            cached = new QueryParserCacheEntry(parseRes.parametersMeta(), parseRes.select(), parseRes.dml(), parseRes.command());
            this.cache.put((Object)qryDesc, (Object)cached);
        }
        return parseRes;
    }

    @Nullable
    private QueryParserResult parseNative(String schemaName, SqlFieldsQuery qry, boolean remainingAllowed) {
        String sql = qry.getSql();
        if (!INTERNAL_CMD_RE.matcher(sql.trim()).find()) {
            return null;
        }
        try {
            SqlParser parser = new SqlParser(schemaName, sql);
            SqlCommand nativeCmd = parser.nextCommand();
            assert (nativeCmd != null) : "Empty query. Parser met end of data";
            if (!this.nativeCmdPredicate.test(nativeCmd)) {
                return null;
            }
            SqlFieldsQuery newQry = QueryParser.cloneFieldsQuery(qry).setSql(parser.lastCommandSql());
            QueryDescriptor newPlanKey = QueryParser.queryDescriptor(schemaName, newQry);
            SqlFieldsQuery remainingQry = null;
            if (!F.isEmpty((String)parser.remainingSql())) {
                QueryParser.checkRemainingAllowed(remainingAllowed);
                remainingQry = QueryParser.cloneFieldsQuery(qry).setSql(parser.remainingSql()).setArgs(qry.getArgs());
            }
            QueryParserResultCommand cmd = new QueryParserResultCommand(nativeCmd, null, false);
            return new QueryParserResult(newPlanKey, this.queryParameters(newQry), remainingQry, Collections.emptyList(), null, null, cmd);
        }
        catch (SqlStrictParseException e) {
            throw new IgniteSQLException(e.getMessage(), e.errorCode(), (Throwable)e);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to parse SQL with native parser [qry=" + sql + ", err=" + e + "]");
            }
            if (!IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_PARSER_DISABLE_H2_FALLBACK")) {
                return null;
            }
            int code = 1001;
            if (e instanceof SqlParseException) {
                code = ((SqlParseException)e).code();
            }
            throw new IgniteSQLException("Failed to parse DDL statement: " + sql + ": " + e.getMessage(), code, (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private QueryParserResult parseH2(String schemaName, SqlFieldsQuery qry, boolean batched, boolean remainingAllowed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkRemainingAllowed(boolean allowed) {
        if (allowed) {
            return;
        }
        throw new IgniteSQLException("Multiple statements queries are not supported.", 1002);
    }

    private QueryParserResultDml prepareDmlStatement(QueryDescriptor planKey, Prepared prepared) {
        UpdatePlan plan;
        if (F.eq((Object)QueryUtils.SCHEMA_SYS, (Object)planKey.schemaName())) {
            throw new IgniteSQLException("DML statements are not supported on " + planKey.schemaName() + " schema", 1002);
        }
        GridSqlQueryParser parser = new GridSqlQueryParser(false, this.log);
        GridSqlStatement stmt = parser.parse(prepared);
        List<GridH2Table> tbls = parser.tablesForDml();
        for (GridH2Table h2tbl : tbls) {
            H2Utils.checkAndStartNotStartedCache(this.idx.kernalContext(), h2tbl.cacheInfo());
        }
        GridH2Table streamTbl = null;
        if (GridSqlQueryParser.isStreamableInsertStatement(prepared)) {
            GridSqlInsert insert = (GridSqlInsert)stmt;
            streamTbl = DmlAstUtils.gridTableForElement(insert.into()).dataTable();
        }
        try {
            plan = UpdatePlanBuilder.planForStatement(planKey, stmt, this.idx, this.log, this.forceFillAbsentPKsWithDefaults);
        }
        catch (Exception e) {
            if (e instanceof IgniteSQLException) {
                throw (IgniteSQLException)((Object)e);
            }
            throw new IgniteSQLException("Failed to prepare update plan.", (Throwable)e);
        }
        return new QueryParserResultDml(stmt, streamTbl, plan);
    }

    public void clearCache() {
        this.cache = new GridBoundedConcurrentLinkedHashMap(1024);
    }

    private static void checkQueryType(SqlFieldsQuery qry, boolean isQry) {
        Boolean qryFlag;
        Boolean bl = qryFlag = qry instanceof SqlFieldsQueryEx ? ((SqlFieldsQueryEx)qry).isQuery() : null;
        if (qryFlag != null && qryFlag != isQry) {
            throw new IgniteSQLException("Given statement type does not match that declared by JDBC driver", 3003);
        }
    }

    private static SqlFieldsQuery cloneFieldsQuery(SqlFieldsQuery oldQry) {
        return oldQry.copy().setLocal(oldQry.isLocal()).setPageSize(oldQry.getPageSize());
    }

    private static QueryDescriptor queryDescriptor(String schemaName, SqlFieldsQuery qry) {
        boolean skipReducerOnUpdate = false;
        boolean batched = false;
        if (qry instanceof SqlFieldsQueryEx) {
            SqlFieldsQueryEx qry0 = (SqlFieldsQueryEx)qry;
            skipReducerOnUpdate = !qry.isLocal() && qry0.isSkipReducerOnUpdate();
            batched = qry0.isBatched();
        }
        return new QueryDescriptor(schemaName, qry.getSql(), qry.isCollocated(), qry.isDistributedJoins(), qry.isEnforceJoinOrder(), qry.isLocal(), skipReducerOnUpdate, batched, qry.getQueryInitiatorId());
    }
}

