/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionPruningContext;
import org.apache.ignite.internal.processors.query.calcite.metadata.AffinityService;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.prepare.AbstractQueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseDataContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExecutionPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryTemplate;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMultiStepPlan
extends AbstractQueryPlan
implements MultiStepPlan {
    protected final FieldsMetadata fieldsMetadata;
    protected final FieldsMetadata paramsMetadata;
    protected final QueryTemplate queryTemplate;
    private final String textPlan;

    protected AbstractMultiStepPlan(String qry, String textPlan, QueryTemplate queryTemplate, FieldsMetadata fieldsMetadata, @Nullable FieldsMetadata paramsMetadata) {
        super(qry);
        this.textPlan = textPlan;
        this.queryTemplate = queryTemplate;
        this.fieldsMetadata = fieldsMetadata;
        this.paramsMetadata = paramsMetadata;
    }

    @Override
    public FieldsMetadata fieldsMetadata() {
        return this.fieldsMetadata;
    }

    @Override
    public FieldsMetadata paramsMetadata() {
        return this.paramsMetadata;
    }

    @Override
    public ExecutionPlan init(MappingService mappingService, AffinityService affSvc, MappingQueryContext mapCtx) {
        ExecutionPlan executionPlan0 = this.queryTemplate.map(mappingService, mapCtx);
        if (F.isEmpty(executionPlan0.fragments())) {
            return executionPlan0;
        }
        if (!F.isEmpty((int[])mapCtx.partitions())) {
            List<Fragment> fragments = executionPlan0.fragments();
            fragments = Commons.transform(fragments, f -> {
                try {
                    return f.filterByPartitions(mapCtx.partitions());
                }
                catch (ColocationMappingException e) {
                    throw new FragmentMappingException("Failed to calculate physical distribution", (Fragment)f, (RelNode)f.root(), e);
                }
            });
            return new ExecutionPlan(executionPlan0.topologyVersion(), fragments, executionPlan0.partitionNodes());
        }
        if (!mapCtx.isLocal() && mapCtx.unwrap(BaseQueryContext.class) != null) {
            BaseQueryContext qryCtx = mapCtx.unwrap(BaseQueryContext.class);
            List<Fragment> fragments = executionPlan0.fragments();
            List<PartitionNode> partNodes = executionPlan0.partitionNodes();
            fragments = Commons.transform(Pair.zip(fragments, partNodes), pair -> {
                int[] parts;
                Fragment fragment = (Fragment)pair.left;
                PartitionNode partNode = (PartitionNode)pair.right;
                Collection<Integer> parts0 = partNode.apply(new PartitionPruningContext(affSvc, new BaseDataContext(qryCtx.typeFactory()), mapCtx.queryParameters()));
                if (parts0 == null) {
                    return fragment;
                }
                int[] nArray = parts = !parts0.isEmpty() ? Ints.toArray(parts0) : U.EMPTY_INTS;
                if (parts.length > 1) {
                    Arrays.sort(parts);
                }
                try {
                    return fragment.filterByPartitions(parts);
                }
                catch (ColocationMappingException e) {
                    throw new FragmentMappingException("Failed to calculate physical distribution", fragment, (RelNode)fragment.root(), e);
                }
            });
            return new ExecutionPlan(executionPlan0.topologyVersion(), fragments, partNodes);
        }
        return executionPlan0;
    }

    @Override
    public String textPlan() {
        return this.textPlan;
    }
}

