/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteSort
extends Sort
implements IgniteRel {
    private final boolean enforcer;

    public IgniteSort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch, boolean enforcer) {
        super(cluster, traits, child, collation, offset, fetch);
        this.enforcer = enforcer;
    }

    public IgniteSort(RelOptCluster cluster, RelTraitSet traits, RelNode child, RelCollation collation, boolean enforcer) {
        this(cluster, traits, child, collation, null, null, enforcer);
    }

    public IgniteSort(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
        this.enforcer = false;
    }

    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new IgniteSort(this.getCluster(), traitSet, newInput, traitSet.getCollation(), offset, fetch, this.enforcer);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public RelCollation collation() {
        return this.collation;
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        RelCollation relCollation;
        if (this.isEnforcer() || required.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        RelCollation requiredCollation = TraitUtils.collation(required);
        if (!requiredCollation.satisfies((RelTrait)(relCollation = this.traitSet.getCollation()))) {
            return null;
        }
        return Pair.of((Object)required, (Object)ImmutableList.of((Object)required.replace((RelTrait)RelCollations.EMPTY)));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        assert (childId == 0);
        if (this.isEnforcer() || childTraits.getConvention() != IgniteConvention.INSTANCE) {
            return null;
        }
        return Pair.of((Object)childTraits.replace((RelTrait)this.collation()), (Object)ImmutableList.of((Object)childTraits));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.memRows(mq.getRowCount(this.getInput()));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double inputRows = mq.getRowCount(this.getInput());
        double memRows = this.memRows(inputRows);
        double cpuCost = inputRows * 1.0 + Util.nLogM((double)inputRows, (double)memRows) * 3.0;
        double memory = memRows * (double)this.getRowType().getFieldCount() * 4.0;
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        RelOptCost cost = costFactory.makeCost(inputRows, cpuCost, 0.0, memory, 0.0);
        if (TraitUtils.distribution(this.traitSet).satisfies((RelTrait)IgniteDistributions.single())) {
            cost.plus(costFactory.makeTinyCost());
        }
        return cost;
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteSort(cluster, this.getTraitSet(), (RelNode)IgniteSort.sole(inputs), this.collation, this.offset, this.fetch, this.enforcer);
    }

    public boolean isEnforcer() {
        return this.enforcer;
    }

    private double memRows(double inputRows) {
        double fetch = this.fetch != null ? RexUtils.doubleFromRex(this.fetch, inputRows * 0.01) : inputRows;
        double offset = this.offset != null ? RexUtils.doubleFromRex(this.offset, inputRows * 0.5) : 0.0;
        return Math.min(inputRows, fetch + offset);
    }
}

