/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.deployment.uri.scanners.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.deployment.uri.scanners.GridDeploymentFileHandler;
import org.apache.ignite.spi.deployment.uri.scanners.GridDeploymentFolderScannerHelper;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScanner;
import org.apache.ignite.spi.deployment.uri.scanners.UriDeploymentScannerContext;

public class UriDeploymentFileScanner
implements UriDeploymentScanner {
    public static final int DFLT_SCAN_FREQ = 5000;
    private final ConcurrentHashMap<URI, URIContext> uriCtxs = new ConcurrentHashMap();

    @Override
    public boolean acceptsURI(URI uri) {
        String proto = uri.getScheme().toLowerCase();
        return "file".equals(proto);
    }

    @Override
    public void scan(UriDeploymentScannerContext scanCtx) {
        URIContext oldUriCtx;
        URI uri = scanCtx.getUri();
        URIContext uriCtx = this.uriCtxs.get(uri);
        if (uriCtx == null && (oldUriCtx = this.uriCtxs.putIfAbsent(uri, uriCtx = this.createUriContext(uri, scanCtx))) != null) {
            uriCtx = oldUriCtx;
        }
        uriCtx.scan(scanCtx);
    }

    @Override
    public long getDefaultScanFrequency() {
        return 5000L;
    }

    private URIContext createUriContext(URI uri, final UriDeploymentScannerContext scanCtx) {
        String scanDirPath = uri.getPath();
        File scanDir = null;
        if (scanDirPath != null) {
            scanDir = new File(scanDirPath);
        }
        if (scanDir == null || !scanDir.isDirectory()) {
            throw new IgniteSpiException("URI is either not provided or is not a directory: " + U.hidePassword((String)uri.toString()));
        }
        FileFilter pkgFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return scanCtx.getFilter().accept(null, pathname.getName());
            }
        };
        FileFilter pkgDirFilesFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile();
            }
        };
        return new URIContext(scanDir, pkgFilter, pkgDirFilesFilter);
    }

    private static String getFileUri(String name) {
        assert (name != null);
        return "file://" + (Serializable)((name = name.replace("\\", "/")).charAt(0) == '/' ? "" : Character.valueOf('/')) + name;
    }

    private static class URIContext {
        private final File scanDir;
        private final FileFilter pkgFilter;
        private final FileFilter pkgDirFilesFilter;
        private final Map<File, Long> tstampCache = new HashMap<File, Long>();
        private final Map<File, Map<File, Long>> pkgDirFilesTstampCache = new HashMap<File, Map<File, Long>>();

        private URIContext(File scanDir, FileFilter pkgFilter, FileFilter pkgDirFilesFilter) {
            this.scanDir = scanDir;
            this.pkgFilter = pkgFilter;
            this.pkgDirFilesFilter = pkgDirFilesFilter;
        }

        private void scan(final UriDeploymentScannerContext scanCtx) {
            final HashSet foundFiles = scanCtx.isFirstScan() ? new HashSet() : U.newHashSet((int)this.tstampCache.size());
            GridDeploymentFileHandler hnd = new GridDeploymentFileHandler(){

                @Override
                public void handle(File file) {
                    foundFiles.add(file);
                    this.handleFile(file, scanCtx);
                }
            };
            GridDeploymentFolderScannerHelper.scanFolder(this.scanDir, this.pkgFilter, hnd);
            if (scanCtx.isFirstScan() && foundFiles.isEmpty()) {
                U.warn((IgniteLogger)scanCtx.getLogger(), (Object)("No packages found in: " + U.hidePassword((String)scanCtx.getUri().toString())));
            }
            if (!scanCtx.isFirstScan()) {
                HashSet<File> deletedFiles = new HashSet<File>(this.tstampCache.keySet());
                deletedFiles.removeAll(foundFiles);
                if (!deletedFiles.isEmpty()) {
                    ArrayList<String> uris = new ArrayList<String>();
                    for (File file : deletedFiles) {
                        uris.add(UriDeploymentFileScanner.getFileUri(file.getAbsolutePath()));
                    }
                    this.tstampCache.keySet().removeAll(deletedFiles);
                    this.pkgDirFilesTstampCache.keySet().removeAll(deletedFiles);
                    scanCtx.getListener().onDeletedFiles(uris);
                }
            }
        }

        private void handleFile(File file, UriDeploymentScannerContext ctx) {
            Long lastMod;
            boolean changed;
            if (file.isDirectory()) {
                GridTuple dirLastModified = F.t((Object)file.lastModified());
                changed = this.checkPackageDirectoryChanged(file, (GridTuple<Long>)dirLastModified);
                lastMod = (Long)dirLastModified.get();
            } else {
                lastMod = this.tstampCache.get(file);
                changed = lastMod == null || lastMod.longValue() != file.lastModified();
                lastMod = file.lastModified();
            }
            if (changed) {
                this.tstampCache.put(file, lastMod);
                if (ctx.getLogger().isDebugEnabled()) {
                    ctx.getLogger().debug("Discovered deployment file or directory: " + file);
                }
                String fileName = file.getName();
                try {
                    File cpFile = ctx.createTempFile(fileName, ctx.getDeployDirectory());
                    cpFile.deleteOnExit();
                    if (file.isDirectory()) {
                        cpFile = new File(cpFile.getParent(), "dir_" + cpFile.getName());
                        cpFile.deleteOnExit();
                    }
                    U.copy((File)file, (File)cpFile, (boolean)true);
                    String fileUri = UriDeploymentFileScanner.getFileUri(file.getAbsolutePath());
                    assert (lastMod != null);
                    ctx.getListener().onNewOrUpdatedFile(cpFile, fileUri, lastMod);
                }
                catch (IOException e) {
                    U.error((IgniteLogger)ctx.getLogger(), (Object)("Error saving file: " + fileName), (Throwable)e);
                }
            }
        }

        private boolean checkPackageDirectoryChanged(File dir, final GridTuple<Long> lastModified) {
            Map<File, Long> clssTstampCache;
            boolean firstScan = false;
            if (!this.pkgDirFilesTstampCache.containsKey(dir)) {
                firstScan = true;
                clssTstampCache = new HashMap<File, Long>();
                this.pkgDirFilesTstampCache.put(dir, clssTstampCache);
            } else {
                clssTstampCache = this.pkgDirFilesTstampCache.get(dir);
            }
            assert (clssTstampCache != null);
            final GridTuple changed = F.t((Object)false);
            final HashSet foundFiles = firstScan ? new HashSet() : U.newHashSet((int)clssTstampCache.size());
            GridDeploymentFileHandler hnd = new GridDeploymentFileHandler(){

                @Override
                public void handle(File file) {
                    foundFiles.add(file);
                    Long fileLastModified = (Long)clssTstampCache.get(file);
                    if (fileLastModified == null || fileLastModified.longValue() != file.lastModified()) {
                        fileLastModified = file.lastModified();
                        clssTstampCache.put(file, fileLastModified);
                        changed.set((Object)true);
                    }
                    if (fileLastModified > (Long)lastModified.get()) {
                        lastModified.set((Object)fileLastModified);
                    }
                }
            };
            GridDeploymentFolderScannerHelper.scanFolder(dir, this.pkgDirFilesFilter, hnd);
            if (!firstScan && clssTstampCache.keySet().retainAll(foundFiles)) {
                changed.set((Object)true);
            }
            return (Boolean)changed.get();
        }
    }
}

