/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.GridJobContextImpl;
import org.apache.ignite.internal.GridJobSiblingImpl;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridJobResultImpl
implements ComputeJobResult {
    private final ComputeJob job;
    private final GridJobSiblingImpl sib;
    private final GridJobContextImpl jobCtx;
    private ClusterNode node;
    private Object data;
    private IgniteException ex;
    private boolean hasRes;
    private boolean isCancelled;
    private boolean isOccupied;

    public GridJobResultImpl(ComputeJob job, IgniteUuid jobId, ClusterNode node, GridJobSiblingImpl sib) {
        assert (jobId != null);
        assert (node != null);
        assert (sib != null);
        this.job = job;
        this.node = node;
        this.sib = sib;
        this.jobCtx = new GridJobContextImpl(null, jobId);
    }

    public ComputeJob getJob() {
        return this.job;
    }

    @Override
    public ComputeJobContext getJobContext() {
        return this.jobCtx;
    }

    public GridJobSiblingImpl getSibling() {
        return this.sib;
    }

    @Override
    public synchronized ClusterNode getNode() {
        return this.node;
    }

    public synchronized Object getData() {
        return this.data;
    }

    @Override
    public synchronized IgniteException getException() {
        return this.ex;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    public synchronized void setNode(ClusterNode node) {
        this.node = node;
    }

    public synchronized void onResponse(@Nullable Object data, @Nullable IgniteException ex, @Nullable Map<Object, Object> jobAttrs, boolean isCancelled) {
        this.data = data;
        this.ex = ex;
        this.isCancelled = isCancelled;
        if (jobAttrs != null) {
            this.jobCtx.setAttributes(jobAttrs);
        }
        this.hasRes = true;
    }

    public synchronized void setOccupied(boolean isOccupied) {
        this.isOccupied = isOccupied;
    }

    public synchronized boolean isOccupied() {
        return this.isOccupied;
    }

    public synchronized void clearData() {
        this.data = null;
    }

    public synchronized void resetResponse() {
        this.data = null;
        this.ex = null;
        this.hasRes = false;
    }

    public synchronized boolean hasResponse() {
        return this.hasRes;
    }

    public String toString() {
        return S.toString(GridJobResultImpl.class, this);
    }
}

