/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteAbstractSqlAlterZone;
import org.apache.ignite3.internal.sql.engine.sql.IgniteDdlOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlAlterZoneSet
extends IgniteAbstractSqlAlterZone {
    private final SqlNodeList optionList;

    public IgniteSqlAlterZoneSet(SqlParserPos pos, SqlIdentifier name, SqlNodeList optionList, boolean ifExists) {
        super(new Operator(ifExists), pos, name);
        this.optionList = Objects.requireNonNull(optionList, "optionList");
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.optionList);
    }

    @Override
    protected void unparseAlterZoneOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("SET");
        if (!this.optionList.isEmpty()) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            for (SqlNode c : this.optionList) {
                writer.sep(",");
                c.unparse(writer, 0, 0);
            }
            writer.endList(frame);
        }
    }

    public SqlNodeList alterOptionsList() {
        return this.optionList;
    }

    protected static class Operator
    extends IgniteDdlOperator {
        private Operator(boolean existFlag) {
            super("ALTER ZONE", SqlKind.OTHER_DDL, existFlag);
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlAlterZoneSet(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], this.existFlag());
        }
    }
}

