/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.worker.balance;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.bifromq.basekv.balance.BalanceNow;
import org.apache.bifromq.basekv.balance.BalanceResult;
import org.apache.bifromq.basekv.balance.NoNeedBalance;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.command.BalanceCommand;
import org.apache.bifromq.basekv.balance.command.SplitCommand;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.proto.SplitHint;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.utils.DescriptorUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.basekv.utils.KVRangeIdUtil;

class DistWorkerSplitBalancer
extends StoreBalancer {
    private static final double DEFAULT_CPU_USAGE_LIMIT = 0.8;
    private static final int DEFAULT_MAX_IO_DENSITY_PER_RANGE = 30;
    private static final long DEFAULT_IO_NANOS_LIMIT_PER_RANGE = 30000L;
    private final double cpuUsageLimit;
    private final int maxIODensityPerRange;
    private final long ioNanosLimitPerRange;
    private volatile Set<KVRangeStoreDescriptor> latestStoreDescriptors = Collections.emptySet();

    public DistWorkerSplitBalancer(String clusterId, String localStoreId) {
        this(clusterId, localStoreId, 0.8, 30, 30000L);
    }

    public DistWorkerSplitBalancer(String clusterId, String localStoreId, double cpuUsageLimit, int maxIoDensityPerRange, long ioNanoLimitPerRange) {
        super(clusterId, localStoreId);
        Preconditions.checkArgument((0.0 < cpuUsageLimit && cpuUsageLimit < 1.0 ? 1 : 0) != 0, (Object)"Invalid cpu usage limit");
        this.cpuUsageLimit = cpuUsageLimit;
        this.maxIODensityPerRange = maxIoDensityPerRange;
        this.ioNanosLimitPerRange = ioNanoLimitPerRange;
    }

    public void update(Set<KVRangeStoreDescriptor> landscape) {
        Optional effectiveEpoch = DescriptorUtil.getEffectiveEpoch(landscape);
        if (effectiveEpoch.isEmpty()) {
            return;
        }
        this.latestStoreDescriptors = ((EffectiveEpoch)effectiveEpoch.get()).storeDescriptors();
    }

    public BalanceResult balance() {
        KVRangeStoreDescriptor localStoreDesc = null;
        for (KVRangeStoreDescriptor d : this.latestStoreDescriptors) {
            if (!d.getId().equals(this.localStoreId)) continue;
            localStoreDesc = d;
            break;
        }
        if (localStoreDesc == null) {
            this.log.warn("There is no storeDescriptor for local store[{}]", (Object)this.localStoreId);
            return NoNeedBalance.INSTANCE;
        }
        double cpuUsage = (Double)localStoreDesc.getStatisticsMap().get("cpu.usage");
        if (cpuUsage > this.cpuUsageLimit) {
            this.log.warn("High CPU usage[{}], temporarily disable FanoutSplitBalancer for local store[{}]", (Object)cpuUsage, (Object)this.localStoreId);
            return NoNeedBalance.INSTANCE;
        }
        Optional<SplitCommand> fanoutBalanceCmd = this.balanceFanout(localStoreDesc);
        if (fanoutBalanceCmd.isPresent()) {
            return BalanceNow.of((BalanceCommand)fanoutBalanceCmd.get());
        }
        return this.balanceMutationLoad(localStoreDesc);
    }

    private Optional<SplitCommand> balanceFanout(KVRangeStoreDescriptor localStoreDesc) {
        List<KVRangeDescriptor> localLeaderRangeDescriptors = localStoreDesc.getRangesList().stream().filter(d -> d.getRole() == RaftNodeStatus.Leader).filter(d -> d.getState() == State.StateType.Normal).filter(d -> d.getHintsList().stream().anyMatch(hint -> hint.getType().equals("fanout_split_hinter"))).sorted((o1, o2) -> {
            int c1 = Double.compare(o2.getHints(0).getLoadOrDefault("fanout_topicfilters", 0.0), o1.getHints(0).getLoadOrDefault("fanout_topicfilters", 0.0));
            if (c1 != 0) {
                return c1;
            }
            return Double.compare(o2.getHints(0).getLoadOrDefault("fanout_scale", 0.0), o1.getHints(0).getLoadOrDefault("fanout_scale", 0.0));
        }).toList();
        if (localLeaderRangeDescriptors.isEmpty()) {
            return Optional.empty();
        }
        for (KVRangeDescriptor leaderRangeDescriptor : localLeaderRangeDescriptors) {
            Optional<SplitHint> splitHint = leaderRangeDescriptor.getHintsList().stream().filter(h -> h.getType().equals("fanout_split_hinter")).findFirst();
            assert (splitHint.isPresent());
            if (!splitHint.get().hasSplitKey()) continue;
            return Optional.of(((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)SplitCommand.builder().toStore(this.localStoreId)).expectedVer(leaderRangeDescriptor.getVer())).kvRangeId(leaderRangeDescriptor.getId())).splitKey(splitHint.get().getSplitKey()).build());
        }
        return Optional.empty();
    }

    private BalanceResult balanceMutationLoad(KVRangeStoreDescriptor localStoreDesc) {
        List<KVRangeDescriptor> localLeaderRangeDescriptors = localStoreDesc.getRangesList().stream().filter(d -> d.getRole() == RaftNodeStatus.Leader).filter(d -> d.getState() == State.StateType.Normal).filter(d -> d.getHintsList().stream().anyMatch(hint -> hint.getType().equals("kv_io_mutation"))).sorted((o1, o2) -> Double.compare(o2.getHints(0).getLoadOrDefault("ioDensity", 0.0), o1.getHints(0).getLoadOrDefault("ioDensity", 0.0))).toList();
        if (localLeaderRangeDescriptors.isEmpty()) {
            return NoNeedBalance.INSTANCE;
        }
        for (KVRangeDescriptor leaderRangeDescriptor : localLeaderRangeDescriptors) {
            Optional<SplitHint> splitHintOpt = leaderRangeDescriptor.getHintsList().stream().filter(h -> h.getType().equals("kv_io_mutation")).findFirst();
            assert (splitHintOpt.isPresent());
            SplitHint splitHint = splitHintOpt.get();
            if (!(splitHint.getLoadOrDefault("ioLatencyNanos", 0.0) < (double)this.ioNanosLimitPerRange) || !(splitHint.getLoadOrDefault("ioDensity", 0.0) > (double)this.maxIODensityPerRange) || !splitHint.hasSplitKey()) continue;
            this.log.debug("Split range[{}] in store[{}]: key={}", new Object[]{KVRangeIdUtil.toString((KVRangeId)leaderRangeDescriptor.getId()), this.localStoreId, splitHint.getSplitKey()});
            return BalanceNow.of((BalanceCommand)((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)((SplitCommand.SplitCommandBuilder)SplitCommand.builder().toStore(this.localStoreId)).expectedVer(leaderRangeDescriptor.getVer())).kvRangeId(leaderRangeDescriptor.getId())).splitKey(splitHint.getSplitKey()).build());
        }
        return NoNeedBalance.INSTANCE;
    }
}

