/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.utils;

import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.utils.KubernetesApplication;
import org.apache.livy.utils.KubernetesClientFactory$;
import org.apache.livy.utils.KubernetesExtensions;
import org.apache.livy.utils.KubernetesExtensions$;
import org.apache.livy.utils.SparkKubernetesApp;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SparkKubernetesApp$
implements Logging {
    public static final SparkKubernetesApp$ MODULE$;
    private final ConcurrentHashMap<String, Object> org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags;
    private final ConcurrentHashMap<Thread, Object> org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap;
    private final ConcurrentLinkedQueue<SparkKubernetesApp> org$apache$livy$utils$SparkKubernetesApp$$appQueue;
    private final Thread leakedAppsGCThread;
    private final Thread RefreshServiceAccountTokenThread;
    private final Thread checkMonitorAppTimeoutThread;
    private LivyConf org$apache$livy$utils$SparkKubernetesApp$$livyConf;
    private int org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize;
    private FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout;
    private FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$pollInterval;
    private long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout;
    private long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval;
    private DefaultKubernetesClient kubernetesClient;
    private long appLookupThreadPoolSize;
    private long org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SparkKubernetesApp$();
    }

    private Logger logger$lzycompute() {
        SparkKubernetesApp$ sparkKubernetesApp$ = this;
        synchronized (sparkKubernetesApp$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public ConcurrentHashMap<String, Object> org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags;
    }

    public ConcurrentHashMap<Thread, Object> org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap;
    }

    public ConcurrentLinkedQueue<SparkKubernetesApp> org$apache$livy$utils$SparkKubernetesApp$$appQueue() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appQueue;
    }

    private Thread leakedAppsGCThread() {
        return this.leakedAppsGCThread;
    }

    public Thread RefreshServiceAccountTokenThread() {
        return this.RefreshServiceAccountTokenThread;
    }

    private Thread checkMonitorAppTimeoutThread() {
        return this.checkMonitorAppTimeoutThread;
    }

    public LivyConf org$apache$livy$utils$SparkKubernetesApp$$livyConf() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$livyConf;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$livyConf_$eq(LivyConf x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$livyConf = x$1;
    }

    public int org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize_$eq(int x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize = x$1;
    }

    public FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout_$eq(FiniteDuration x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout = x$1;
    }

    public FiniteDuration org$apache$livy$utils$SparkKubernetesApp$$pollInterval() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$pollInterval;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$pollInterval_$eq(FiniteDuration x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$pollInterval = x$1;
    }

    public long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout_$eq(long x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout = x$1;
    }

    public long org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval_$eq(long x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval = x$1;
    }

    public DefaultKubernetesClient kubernetesClient() {
        return this.kubernetesClient;
    }

    public void kubernetesClient_$eq(DefaultKubernetesClient x$1) {
        this.kubernetesClient = x$1;
    }

    private long appLookupThreadPoolSize() {
        return this.appLookupThreadPoolSize;
    }

    private void appLookupThreadPoolSize_$eq(long x$1) {
        this.appLookupThreadPoolSize = x$1;
    }

    public long org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes;
    }

    private void org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes_$eq(long x$1) {
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes = x$1;
    }

    public void init(LivyConf livyConf, Option<KubernetesClient> client) {
        this.org$apache$livy$utils$SparkKubernetesApp$$livyConf_$eq(livyConf);
        this.kubernetesClient_$eq(KubernetesClientFactory$.MODULE$.createKubernetesClient(livyConf));
        this.org$apache$livy$utils$SparkKubernetesApp$$cacheLogSize_$eq(livyConf.getInt(LivyConf$.MODULE$.SPARK_LOGS_SIZE()));
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout_$eq(new package.DurationLong(package$.MODULE$.DurationLong(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_TIMEOUT()))).milliseconds());
        this.org$apache$livy$utils$SparkKubernetesApp$$pollInterval_$eq(new package.DurationLong(package$.MODULE$.DurationLong(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_POLL_INTERVAL()))).milliseconds());
        this.appLookupThreadPoolSize_$eq(livyConf.getInt(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_THREAD_POOL_SIZE()));
        this.org$apache$livy$utils$SparkKubernetesApp$$appLookupMaxFailedTimes_$eq(livyConf.getInt(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_MAX_FAILED_TIMES()));
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval_$eq(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_APP_LEAKAGE_CHECK_INTERVAL()));
        this.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout_$eq(livyConf.getTimeAsMs(LivyConf$.MODULE$.KUBERNETES_APP_LEAKAGE_CHECK_TIMEOUT()));
        this.leakedAppsGCThread().setDaemon(true);
        this.leakedAppsGCThread().setName("LeakedAppsGCThread");
        this.leakedAppsGCThread().start();
        this.RefreshServiceAccountTokenThread().setName("RefreshServiceAccountTokenThread");
        this.RefreshServiceAccountTokenThread().setDaemon(true);
        this.RefreshServiceAccountTokenThread().start();
        this.checkMonitorAppTimeoutThread().setDaemon(true);
        this.checkMonitorAppTimeoutThread().setName("CheckMonitorAppTimeoutThread");
        this.checkMonitorAppTimeoutThread().start();
        this.initKubernetesAppMonitorThreadPool(livyConf);
    }

    public Option<KubernetesClient> init$default$2() {
        return None$.MODULE$;
    }

    public <T> T org$apache$livy$utils$SparkKubernetesApp$$withRetry(Function0<T> fn, int n, long retryBackoff) {
        Try try_;
        while (true) {
            if ((try_ = Try$.MODULE$.apply(fn)) instanceof Success) {
                Object x;
                Success success = (Success)try_;
                Object object = x = success.value();
                return (T)object;
            }
            if (n <= 1) break;
            Thread.sleep(Math.max(retryBackoff, 3000L));
            retryBackoff = this.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3();
            --n;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    public <T> int org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$2() {
        return 10;
    }

    public <T> long org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3() {
        return 3000L;
    }

    private void initKubernetesAppMonitorThreadPool(LivyConf livyConf) {
        int poolSize = livyConf.getInt(LivyConf$.MODULE$.KUBERNETES_APP_LOOKUP_THREAD_POOL_SIZE());
        ExecutorService KubernetesAppMonitorThreadPool = Executors.newFixedThreadPool(poolSize);
        SparkKubernetesApp.KubernetesAppMonitorRunnable runnable = new SparkKubernetesApp.KubernetesAppMonitorRunnable();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), poolSize).foreach$mVc$sp((Function1)new Serializable(KubernetesAppMonitorThreadPool, runnable){
            public static final long serialVersionUID = 0L;
            private final ExecutorService KubernetesAppMonitorThreadPool$1;
            private final SparkKubernetesApp.KubernetesAppMonitorRunnable runnable$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.KubernetesAppMonitorThreadPool$1.execute(this.runnable$1);
            }
            {
                this.KubernetesAppMonitorThreadPool$1 = KubernetesAppMonitorThreadPool$1;
                this.runnable$1 = runnable$1;
            }
        });
    }

    public int getAppSize() {
        return this.org$apache$livy$utils$SparkKubernetesApp$$appQueue().size();
    }

    public void clearApps() {
        this.org$apache$livy$utils$SparkKubernetesApp$$appQueue().clear();
    }

    public KubernetesClient $lessinit$greater$default$6() {
        return this.kubernetesClient();
    }

    private SparkKubernetesApp$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags = new ConcurrentHashMap();
        this.org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap = new ConcurrentHashMap();
        this.org$apache$livy$utils$SparkKubernetesApp$$appQueue = new ConcurrentLinkedQueue();
        this.leakedAppsGCThread = new Thread(){

            public void run() {
                while (true) {
                    if (!SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags().isEmpty()) {
                        Iterator<Map.Entry<String, Object>> iter = SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$leakedAppTags().entrySet().iterator();
                        BooleanRef isRemoved = BooleanRef.create((boolean)false);
                        long now = System.currentTimeMillis();
                        Seq apps = (Seq)SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<KubernetesApplication> apply() {
                                KubernetesExtensions.KubernetesClientExtensions qual$1 = KubernetesExtensions$.MODULE$.KubernetesClientExtensions((KubernetesClient)SparkKubernetesApp$.MODULE$.kubernetesClient());
                                Map<String, String> x$26 = qual$1.getApplications$default$1();
                                String x$27 = qual$1.getApplications$default$2();
                                String x$28 = qual$1.getApplications$default$3();
                                return qual$1.getApplications(x$26, x$27, x$28);
                            }
                        }, SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$2(), SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3());
                        while (iter.hasNext()) {
                            Map.Entry<String, Object> entry = iter.next();
                            apps.find((Function1)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final boolean apply(KubernetesApplication x$1) {
                                    return x$1.getApplicationTag().contains((CharSequence)this.entry$1.getKey());
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            }).foreach((Function1)new Serializable(this, iter, isRemoved){
                                public static final long serialVersionUID = 0L;
                                private final Iterator iter$1;
                                private final BooleanRef isRemoved$1;

                                public final void apply(KubernetesApplication app) {
                                    SparkKubernetesApp$.MODULE$.info((Function0<Object>)new Serializable(this, app){
                                        public static final long serialVersionUID = 0L;
                                        private final KubernetesApplication app$3;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kill leaked app ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.app$3.getApplicationId()}));
                                        }
                                        {
                                            this.app$3 = app$3;
                                        }
                                    });
                                    SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry(new Serializable(this, app){
                                        public static final long serialVersionUID = 0L;
                                        private final KubernetesApplication app$3;

                                        public final boolean apply() {
                                            return this.apply$mcZ$sp();
                                        }

                                        public boolean apply$mcZ$sp() {
                                            return KubernetesExtensions$.MODULE$.KubernetesClientExtensions((KubernetesClient)SparkKubernetesApp$.MODULE$.kubernetesClient()).killApplication(this.app$3);
                                        }
                                        {
                                            this.app$3 = app$3;
                                        }
                                    }, SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$2(), SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$withRetry$default$3());
                                    this.iter$1.remove();
                                    this.isRemoved$1.elem = true;
                                }
                                {
                                    this.iter$1 = iter$1;
                                    this.isRemoved$1 = isRemoved$1;
                                }
                            });
                            if (isRemoved.elem || BoxesRunTime.unboxToLong((Object)entry.getValue()) - now <= SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckTimeout()) continue;
                            iter.remove();
                            SparkKubernetesApp$.MODULE$.info((Function0<Object>)new Serializable(this, entry){
                                public static final long serialVersionUID = 0L;
                                private final Map.Entry entry$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remove leaked Kubernetes app tag ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.entry$1.getKey()}));
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            });
                        }
                    }
                    Thread.sleep(SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$sessionLeakageCheckInterval());
                }
            }
        };
        this.RefreshServiceAccountTokenThread = new Thread(){

            public void run() {
                while (true) {
                    Context currentContext = new Context();
                    String currentContextName = new String();
                    Config config = SparkKubernetesApp$.MODULE$.kubernetesClient().getConfiguration();
                    if (config.getCurrentContext() != null) {
                        currentContext = config.getCurrentContext().getContext();
                        currentContextName = config.getCurrentContext().getName();
                    }
                    ObjectRef newAccessToken = ObjectRef.create((Object)new String());
                    Config newestConfig = Config.autoConfigure((String)currentContextName);
                    newAccessToken.elem = newestConfig.getOauthToken();
                    SparkKubernetesApp$.MODULE$.info((Function0<Object>)new Serializable(this, newAccessToken){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef newAccessToken$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Refresh a new token ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.newAccessToken$1.elem}));
                        }
                        {
                            this.newAccessToken$1 = newAccessToken$1;
                        }
                    });
                    config.setOauthToken((String)newAccessToken.elem);
                    SparkKubernetesApp$.MODULE$.kubernetesClient_$eq(new DefaultKubernetesClient(config));
                    Thread.sleep(300000L);
                }
            }
        };
        this.checkMonitorAppTimeoutThread = new Thread(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                while (true) {
                    long now;
                    Iterator<Map.Entry<Thread, Object>> iter;
                    try {
                        iter = SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$monitorAppThreadMap().entrySet().iterator();
                        now = System.currentTimeMillis();
                    }
                    catch (InterruptedException interruptedException) {
                        SparkKubernetesApp$.MODULE$.error((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Apps timeout monitoring thread was interrupted.";
                            }
                        }, interruptedException);
                        continue;
                    }
                    {
                        while (iter.hasNext()) {
                            Map.Entry<Thread, Object> entry = iter.next();
                            Thread thread = entry.getKey();
                            long updatedTime = BoxesRunTime.unboxToLong((Object)entry.getValue());
                            long remaining = now - updatedTime - SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$pollInterval().toMillis();
                            if (remaining <= SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$appLookupTimeout().toMillis()) continue;
                            thread.interrupt();
                        }
                        Thread.sleep(SparkKubernetesApp$.MODULE$.org$apache$livy$utils$SparkKubernetesApp$$pollInterval().toMillis());
                        continue;
                    }
                    break;
                }
            }
        };
    }
}

