/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.nosql.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.polaris.nosql.async.AsyncConfiguration;
import org.immutables.value.Generated;

@Generated(from="AsyncConfiguration", generator="Immutables")
public final class ImmutableAsyncConfiguration
implements AsyncConfiguration {
    private final Duration threadKeepAlive;
    private final Integer maxThreads;
    private transient int hashCode;

    private ImmutableAsyncConfiguration(Duration threadKeepAlive, Integer maxThreads) {
        this.threadKeepAlive = threadKeepAlive;
        this.maxThreads = maxThreads;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public Optional<Duration> threadKeepAlive() {
        return Optional.ofNullable(this.threadKeepAlive);
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public OptionalInt maxThreads() {
        return this.maxThreads != null ? OptionalInt.of(this.maxThreads) : OptionalInt.empty();
    }

    public final ImmutableAsyncConfiguration withThreadKeepAlive(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "threadKeepAlive");
        if (this.threadKeepAlive == newValue) {
            return this;
        }
        return new ImmutableAsyncConfiguration(newValue, this.maxThreads);
    }

    public final ImmutableAsyncConfiguration withThreadKeepAlive(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.threadKeepAlive == value) {
            return this;
        }
        return new ImmutableAsyncConfiguration(value, this.maxThreads);
    }

    public final ImmutableAsyncConfiguration withMaxThreads(int value) {
        Integer newValue = value;
        if (Objects.equals(this.maxThreads, newValue)) {
            return this;
        }
        return new ImmutableAsyncConfiguration(this.threadKeepAlive, newValue);
    }

    public final ImmutableAsyncConfiguration withMaxThreads(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.maxThreads, value)) {
            return this;
        }
        return new ImmutableAsyncConfiguration(this.threadKeepAlive, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAsyncConfiguration && this.equalsByValue((ImmutableAsyncConfiguration)another);
    }

    private boolean equalsByValue(ImmutableAsyncConfiguration another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.threadKeepAlive, another.threadKeepAlive) && Objects.equals(this.maxThreads, another.maxThreads);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.threadKeepAlive);
        h += (h << 5) + Objects.hashCode(this.maxThreads);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AsyncConfiguration{");
        if (this.threadKeepAlive != null) {
            builder.append("threadKeepAlive=").append(this.threadKeepAlive);
        }
        if (this.maxThreads != null) {
            if (builder.length() > 19) {
                builder.append(", ");
            }
            builder.append("maxThreads=").append(this.maxThreads);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAsyncConfiguration fromJson(Json json) {
        Builder builder = ImmutableAsyncConfiguration.builder();
        if (json._threadKeepAlive != null) {
            builder.threadKeepAlive(json._threadKeepAlive);
        }
        if (json._maxThreads != null) {
            builder.maxThreads(json._maxThreads);
        }
        return builder.build();
    }

    public static ImmutableAsyncConfiguration copyOf(AsyncConfiguration instance) {
        if (instance instanceof ImmutableAsyncConfiguration) {
            return (ImmutableAsyncConfiguration)instance;
        }
        return ImmutableAsyncConfiguration.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableAsyncConfiguration.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AsyncConfiguration", generator="Immutables")
    public static final class Builder {
        private Duration threadKeepAlive;
        private Integer maxThreads;

        private Builder() {
        }

        public final Builder from(AsyncConfiguration instance) {
            OptionalInt maxThreadsOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Duration> threadKeepAliveOptional = instance.threadKeepAlive();
            if (threadKeepAliveOptional.isPresent()) {
                this.threadKeepAlive(threadKeepAliveOptional);
            }
            if ((maxThreadsOptional = instance.maxThreads()).isPresent()) {
                this.maxThreads(maxThreadsOptional);
            }
            return this;
        }

        public final Builder threadKeepAlive(Duration threadKeepAlive) {
            this.threadKeepAlive = Objects.requireNonNull(threadKeepAlive, "threadKeepAlive");
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonFormat(shape=JsonFormat.Shape.STRING)
        public final Builder threadKeepAlive(Optional<? extends Duration> threadKeepAlive) {
            this.threadKeepAlive = threadKeepAlive.orElse(null);
            return this;
        }

        public final Builder maxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public final Builder maxThreads(OptionalInt maxThreads) {
            this.maxThreads = maxThreads.isPresent() ? Integer.valueOf(maxThreads.getAsInt()) : null;
            return this;
        }

        public Builder clear() {
            this.threadKeepAlive = null;
            this.maxThreads = null;
            return this;
        }

        public ImmutableAsyncConfiguration build() {
            return new ImmutableAsyncConfiguration(this.threadKeepAlive, this.maxThreads);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="AsyncConfiguration", generator="Immutables")
    static final class Json
    implements AsyncConfiguration {
        @JsonIgnore
        Optional<Duration> _threadKeepAlive = Optional.empty();
        @JsonIgnore
        OptionalInt _maxThreads = OptionalInt.empty();

        Json() {
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonFormat(shape=JsonFormat.Shape.STRING)
        public void setThreadKeepAlive(Optional<Duration> threadKeepAlive) {
            this._threadKeepAlive = threadKeepAlive;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public void setMaxThreads(OptionalInt maxThreads) {
            this._maxThreads = maxThreads;
        }

        @Override
        public Optional<Duration> threadKeepAlive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalInt maxThreads() {
            throw new UnsupportedOperationException();
        }
    }
}

