/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntryType;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALSignalEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.LogWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALFileVersion;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALMetaData;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileStatus;

public class WALWriter
extends LogWriter {
    private WALFileStatus walFileStatus = WALFileStatus.CONTAINS_NONE_SEARCH_INDEX;
    protected final WALMetaData metaData = new WALMetaData();
    private WALFileVersion version = WALFileVersion.V2;

    public WALWriter(File logFile) throws IOException {
        this(logFile, WALFileVersion.V2);
    }

    public WALWriter(File logFile, WALFileVersion version) throws IOException {
        super(logFile, version);
        this.version = version;
    }

    public double write(ByteBuffer buffer, WALMetaData metaData) throws IOException {
        this.updateMetaData(metaData);
        return this.write(buffer);
    }

    public void updateMetaData(WALMetaData metaData) {
        this.metaData.addAll(metaData);
    }

    private void endFile() throws IOException {
        WALSignalEntry endMarker = new WALSignalEntry(WALEntryType.WAL_FILE_INFO_END_MARKER);
        ByteBuffer markerBuffer = ByteBuffer.allocate(1);
        endMarker.serialize(markerBuffer);
        this.write(markerBuffer, false);
        int metaDataSize = this.metaData.serializedSize();
        ByteBuffer buffer = ByteBuffer.allocate(metaDataSize + 4 + this.version.getVersionBytes().length);
        this.metaData.serialize(buffer);
        buffer.putInt(metaDataSize);
        buffer.put(this.version.getVersionBytes());
        this.writeMetadata(buffer);
    }

    private void writeMetadata(ByteBuffer buffer) throws IOException {
        buffer.flip();
        this.logChannel.write(buffer);
    }

    @Override
    public void close() throws IOException {
        this.endFile();
        super.close();
    }

    public void updateFileStatus(WALFileStatus walFileStatus) {
        if (walFileStatus == WALFileStatus.CONTAINS_SEARCH_INDEX) {
            this.walFileStatus = WALFileStatus.CONTAINS_SEARCH_INDEX;
        }
    }

    public WALFileStatus getWalFileStatus() {
        return this.walFileStatus;
    }

    public void setVersion(WALFileVersion version) {
        this.version = version;
    }
}

