/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TrustListDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12554");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12676");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12680");
    private final UInteger specifiedLists;
    private final ByteString[] trustedCertificates;
    private final ByteString[] trustedCrls;
    private final ByteString[] issuerCertificates;
    private final ByteString[] issuerCrls;

    public TrustListDataType(UInteger specifiedLists, ByteString[] trustedCertificates, ByteString[] trustedCrls, ByteString[] issuerCertificates, ByteString[] issuerCrls) {
        this.specifiedLists = specifiedLists;
        this.trustedCertificates = trustedCertificates;
        this.trustedCrls = trustedCrls;
        this.issuerCertificates = issuerCertificates;
        this.issuerCrls = issuerCrls;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public UInteger getSpecifiedLists() {
        return this.specifiedLists;
    }

    public ByteString[] getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public ByteString[] getTrustedCrls() {
        return this.trustedCrls;
    }

    public ByteString[] getIssuerCertificates() {
        return this.issuerCertificates;
    }

    public ByteString[] getIssuerCrls() {
        return this.issuerCrls;
    }

    protected TrustListDataType(TrustListDataTypeBuilder<?, ?> b) {
        super(b);
        this.specifiedLists = ((TrustListDataTypeBuilder)b).specifiedLists;
        this.trustedCertificates = ((TrustListDataTypeBuilder)b).trustedCertificates;
        this.trustedCrls = ((TrustListDataTypeBuilder)b).trustedCrls;
        this.issuerCertificates = ((TrustListDataTypeBuilder)b).issuerCertificates;
        this.issuerCrls = ((TrustListDataTypeBuilder)b).issuerCrls;
    }

    public static TrustListDataTypeBuilder<?, ?> builder() {
        return new TrustListDataTypeBuilderImpl();
    }

    public TrustListDataTypeBuilder<?, ?> toBuilder() {
        return new TrustListDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustListDataType)) {
            return false;
        }
        TrustListDataType other = (TrustListDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$specifiedLists = this.getSpecifiedLists();
        UInteger other$specifiedLists = other.getSpecifiedLists();
        if (this$specifiedLists == null ? other$specifiedLists != null : !((Object)this$specifiedLists).equals(other$specifiedLists)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTrustedCertificates(), other.getTrustedCertificates())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTrustedCrls(), other.getTrustedCrls())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIssuerCertificates(), other.getIssuerCertificates())) {
            return false;
        }
        return Arrays.deepEquals(this.getIssuerCrls(), other.getIssuerCrls());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrustListDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $specifiedLists = this.getSpecifiedLists();
        result = result * 59 + ($specifiedLists == null ? 43 : ((Object)$specifiedLists).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTrustedCertificates());
        result = result * 59 + Arrays.deepHashCode(this.getTrustedCrls());
        result = result * 59 + Arrays.deepHashCode(this.getIssuerCertificates());
        result = result * 59 + Arrays.deepHashCode(this.getIssuerCrls());
        return result;
    }

    @Override
    public String toString() {
        return "TrustListDataType(specifiedLists=" + this.getSpecifiedLists() + ", trustedCertificates=" + Arrays.deepToString(this.getTrustedCertificates()) + ", trustedCrls=" + Arrays.deepToString(this.getTrustedCrls()) + ", issuerCertificates=" + Arrays.deepToString(this.getIssuerCertificates()) + ", issuerCrls=" + Arrays.deepToString(this.getIssuerCrls()) + ")";
    }

    private static final class TrustListDataTypeBuilderImpl
    extends TrustListDataTypeBuilder<TrustListDataType, TrustListDataTypeBuilderImpl> {
        private TrustListDataTypeBuilderImpl() {
        }

        @Override
        protected TrustListDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public TrustListDataType build() {
            return new TrustListDataType(this);
        }
    }

    public static abstract class TrustListDataTypeBuilder<C extends TrustListDataType, B extends TrustListDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger specifiedLists;
        private ByteString[] trustedCertificates;
        private ByteString[] trustedCrls;
        private ByteString[] issuerCertificates;
        private ByteString[] issuerCrls;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TrustListDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TrustListDataType instance, TrustListDataTypeBuilder<?, ?> b) {
            b.specifiedLists(instance.specifiedLists);
            b.trustedCertificates(instance.trustedCertificates);
            b.trustedCrls(instance.trustedCrls);
            b.issuerCertificates(instance.issuerCertificates);
            b.issuerCrls(instance.issuerCrls);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B specifiedLists(UInteger specifiedLists) {
            this.specifiedLists = specifiedLists;
            return (B)this.self();
        }

        public B trustedCertificates(ByteString[] trustedCertificates) {
            this.trustedCertificates = trustedCertificates;
            return (B)this.self();
        }

        public B trustedCrls(ByteString[] trustedCrls) {
            this.trustedCrls = trustedCrls;
            return (B)this.self();
        }

        public B issuerCertificates(ByteString[] issuerCertificates) {
            this.issuerCertificates = issuerCertificates;
            return (B)this.self();
        }

        public B issuerCrls(ByteString[] issuerCrls) {
            this.issuerCrls = issuerCrls;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TrustListDataType.TrustListDataTypeBuilder(super=" + super.toString() + ", specifiedLists=" + this.specifiedLists + ", trustedCertificates=" + Arrays.deepToString(this.trustedCertificates) + ", trustedCrls=" + Arrays.deepToString(this.trustedCrls) + ", issuerCertificates=" + Arrays.deepToString(this.issuerCertificates) + ", issuerCrls=" + Arrays.deepToString(this.issuerCrls) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<TrustListDataType> {
        @Override
        public Class<TrustListDataType> getType() {
            return TrustListDataType.class;
        }

        @Override
        public TrustListDataType decode(SerializationContext context, UaDecoder decoder) {
            UInteger specifiedLists = decoder.readUInt32("SpecifiedLists");
            ByteString[] trustedCertificates = decoder.readByteStringArray("TrustedCertificates");
            ByteString[] trustedCrls = decoder.readByteStringArray("TrustedCrls");
            ByteString[] issuerCertificates = decoder.readByteStringArray("IssuerCertificates");
            ByteString[] issuerCrls = decoder.readByteStringArray("IssuerCrls");
            return new TrustListDataType(specifiedLists, trustedCertificates, trustedCrls, issuerCertificates, issuerCrls);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TrustListDataType value) {
            encoder.writeUInt32("SpecifiedLists", value.getSpecifiedLists());
            encoder.writeByteStringArray("TrustedCertificates", value.getTrustedCertificates());
            encoder.writeByteStringArray("TrustedCrls", value.getTrustedCrls());
            encoder.writeByteStringArray("IssuerCertificates", value.getIssuerCertificates());
            encoder.writeByteStringArray("IssuerCrls", value.getIssuerCrls());
        }
    }
}

