/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionRecoverTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private final File compactionLogFile;
    private final boolean isInnerSpace;
    private final String fullStorageGroupName;
    private final TsFileManager tsFileManager;

    public CompactionRecoverTask(String logicalStorageGroupName, String virtualStorageGroupName, TsFileManager tsFileManager, File logFile, boolean isInnerSpace) {
        this.compactionLogFile = logFile;
        this.isInnerSpace = isInnerSpace;
        this.fullStorageGroupName = logicalStorageGroupName + "-" + virtualStorageGroupName;
        this.tsFileManager = tsFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCompaction() {
        boolean recoverSuccess;
        block17: {
            List<TsFileIdentifier> deletedTargetFileIdentifiers;
            List<TsFileIdentifier> targetFileIdentifiers;
            List<TsFileIdentifier> sourceFileIdentifiers;
            block18: {
                block19: {
                    recoverSuccess = true;
                    LOGGER.info("{} [Compaction][Recover] compaction log is {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    if (!this.compactionLogFile.exists()) break block17;
                    LOGGER.info("{} [Compaction][Recover] compaction log file {} exists, start to recover it", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(this.compactionLogFile);
                    logAnalyzer.analyze();
                    sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
                    targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
                    deletedTargetFileIdentifiers = logAnalyzer.getDeletedTargetFileInfos();
                    if (!targetFileIdentifiers.isEmpty() && !sourceFileIdentifiers.isEmpty()) break block18;
                    LOGGER.info("{} [Compaction][Recover] incomplete log file, abort recover", (Object)this.fullStorageGroupName);
                    if (recoverSuccess) break block19;
                    LOGGER.error("{} [Compaction][Recover] Failed to recover compaction", (Object)this.fullStorageGroupName);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e) {
                    LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
                }
                return;
            }
            try {
                boolean isAllSourcesFileExisted = true;
                for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
                    File sourceFile = sourceFileIdentifier.getFileFromDataDirs();
                    if (sourceFile != null) continue;
                    isAllSourcesFileExisted = false;
                    break;
                }
                recoverSuccess = isAllSourcesFileExisted ? this.handleWithAllSourceFilesExist(targetFileIdentifiers, sourceFileIdentifiers) : this.handleWithSomeSourceFilesLost(targetFileIdentifiers, deletedTargetFileIdentifiers, sourceFileIdentifiers);
            }
            catch (IOException e) {
                block20: {
                    try {
                        LOGGER.error("Recover compaction error", (Throwable)e);
                        if (recoverSuccess) break block20;
                    }
                    catch (Throwable throwable) {
                        if (!recoverSuccess) {
                            LOGGER.error("{} [Compaction][Recover] Failed to recover compaction", (Object)this.fullStorageGroupName);
                            throw throwable;
                        }
                        if (!this.compactionLogFile.exists()) throw throwable;
                        try {
                            LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                            FileUtils.delete((File)this.compactionLogFile);
                            throw throwable;
                        }
                        catch (IOException e2) {
                            LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e2});
                        }
                        throw throwable;
                    }
                    LOGGER.error("{} [Compaction][Recover] Failed to recover compaction", (Object)this.fullStorageGroupName);
                    return;
                }
                if (!this.compactionLogFile.exists()) return;
                try {
                    LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                    FileUtils.delete((File)this.compactionLogFile);
                    return;
                }
                catch (IOException e3) {
                    LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e3});
                }
                return;
            }
        }
        if (!recoverSuccess) {
            LOGGER.error("{} [Compaction][Recover] Failed to recover compaction", (Object)this.fullStorageGroupName);
            return;
        } else {
            if (!this.compactionLogFile.exists()) return;
            try {
                LOGGER.info("{} [Compaction][Recover] Recover compaction successfully, delete log file {}", (Object)this.fullStorageGroupName, (Object)this.compactionLogFile);
                FileUtils.delete((File)this.compactionLogFile);
                return;
            }
            catch (IOException e) {
                LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting log file {}", new Object[]{this.fullStorageGroupName, this.compactionLogFile, e});
            }
        }
        return;
    }

    private boolean handleWithAllSourceFilesExist(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) {
        LOGGER.info("{} [Compaction][Recover] all source files exists, delete all target files.", (Object)this.fullStorageGroupName);
        for (TsFileIdentifier tsFileIdentifier : targetFileIdentifiers) {
            File tmpTargetFile = tsFileIdentifier.getFileFromDataDirs();
            File targetFile = this.getFileFromDataDirs(tsFileIdentifier.getFilePath().replace(this.isInnerSpace ? ".inner" : ".cross", ".tsfile"));
            TsFileResource targetResource = null;
            if (tmpTargetFile != null) {
                targetResource = new TsFileResource(tmpTargetFile);
            } else if (targetFile != null) {
                targetResource = new TsFileResource(targetFile);
            }
            if (targetResource == null || targetResource.remove()) continue;
            LOGGER.error("{} [Compaction][Recover] failed to remove target file {}", (Object)this.fullStorageGroupName, (Object)targetResource);
            return false;
        }
        ArrayList<TsFileResource> sourceTsFileResourceList = new ArrayList<TsFileResource>();
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            sourceTsFileResourceList.add(new TsFileResource(sourceFileIdentifier.getFileFromDataDirs()));
        }
        try {
            CompactionUtils.deleteCompactionModsFile(sourceTsFileResourceList, Collections.emptyList());
        }
        catch (IOException iOException) {
            LOGGER.error("{} [Compaction][Recover] Exception occurs while deleting compaction mods file", (Object)this.fullStorageGroupName, (Object)iOException);
            return false;
        }
        return true;
    }

    private boolean handleWithSomeSourceFilesLost(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> deletedTargetFileIdentifiers, List<TsFileIdentifier> sourceFileIdentifiers) throws IOException {
        if (!this.checkIsTargetFilesComplete(targetFileIdentifiers, deletedTargetFileIdentifiers)) {
            return false;
        }
        boolean handleSuccess = true;
        for (TsFileIdentifier sourceFileIdentifier : sourceFileIdentifiers) {
            if (this.deleteFile(sourceFileIdentifier)) continue;
            handleSuccess = false;
        }
        return handleSuccess;
    }

    private File getFileFromDataDirs(String filePath) {
        String[] dataDirs;
        for (String dataDir : dataDirs = IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()) {
            File f = new File(dataDir, filePath);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    private boolean checkIsTargetFilesComplete(List<TsFileIdentifier> targetFileIdentifiers, List<TsFileIdentifier> deletedTargetFileIdentifiers) throws IOException {
        for (TsFileIdentifier targetFileIdentifier : targetFileIdentifiers) {
            targetFileIdentifier.setFilename(targetFileIdentifier.getFilename().replace(this.isInnerSpace ? ".inner" : ".cross", ".tsfile"));
            boolean isTargetFileDeleted = deletedTargetFileIdentifiers.contains(targetFileIdentifier);
            if (isTargetFileDeleted) {
                if (this.deleteFile(targetFileIdentifier)) continue;
                return false;
            }
            File targetFile = this.getFileFromDataDirs(targetFileIdentifier.getFilePath());
            if (targetFile != null && TsFileUtils.isTsFileComplete((File)new TsFileResource(targetFile).getTsFile())) continue;
            LOGGER.error("{} [Compaction][ExceptionHandler] target file {} is not complete, and some source files is lost, do nothing.", (Object)this.fullStorageGroupName, (Object)targetFileIdentifier.getFilePath());
            return false;
        }
        return true;
    }

    private boolean deleteFile(TsFileIdentifier tsFileIdentifier) {
        boolean success = true;
        File file = tsFileIdentifier.getFileFromDataDirs();
        if (!this.checkAndDeleteFile(file)) {
            success = false;
        }
        if (!this.checkAndDeleteFile(file = this.getFileFromDataDirs(tsFileIdentifier.getFilePath() + ".resource"))) {
            success = false;
        }
        if (!this.checkAndDeleteFile(file = this.getFileFromDataDirs(tsFileIdentifier.getFilePath() + ".mods"))) {
            success = false;
        }
        if (!this.checkAndDeleteFile(file = this.getFileFromDataDirs(tsFileIdentifier.getFilePath() + ".compaction.mods"))) {
            success = false;
        }
        return success;
    }

    private boolean checkAndDeleteFile(File file) {
        if (file == null || !file.exists()) {
            return true;
        }
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            LOGGER.error("{} [Compaction][Recover] failed to remove file {}, exception: {}", new Object[]{this.fullStorageGroupName, file, e});
            return false;
        }
        return true;
    }
}

