/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TAINodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ainode.AINodeClient;
import org.apache.iotdb.commons.client.ainode.AINodeClientManager;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.write.ainode.RemoveAINodePlan;
import org.apache.iotdb.confignode.consensus.request.write.model.DropModelInNodePlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.RemoveAINodeState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveAINodeProcedure
extends AbstractNodeProcedure<RemoveAINodeState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveAINodeProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private TAINodeLocation removedAINode;

    public RemoveAINodeProcedure(TAINodeLocation removedAINode) {
        this.removedAINode = removedAINode;
    }

    public RemoveAINodeProcedure() {
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RemoveAINodeState state) throws InterruptedException {
        block21: {
            if (this.removedAINode == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case MODEL_DELETE: {
                        env.getConfigManager().getConsensusManager().write(new DropModelInNodePlan(this.removedAINode.aiNodeId));
                        this.setNextState(RemoveAINodeState.NODE_STOP);
                        break;
                    }
                    case NODE_STOP: {
                        TSStatus resp = null;
                        try (AINodeClient client = (AINodeClient)AINodeClientManager.getInstance().borrowClient((Object)this.removedAINode.getInternalEndPoint());){
                            resp = client.stopAINode();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to stop AINode {}, but the remove process will continue.", (Object)this.removedAINode.getInternalEndPoint());
                        }
                        if (resp != null && resp.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            LOGGER.info("Successfully stopped AINode {}", (Object)this.removedAINode.getInternalEndPoint());
                        } else if (resp != null) {
                            LOGGER.warn("Failed to stop AINode {} because {}, but the remove process will continue.", (Object)resp.getMessage(), (Object)this.removedAINode.getInternalEndPoint());
                        }
                        this.setNextState(RemoveAINodeState.NODE_REMOVE);
                        break;
                    }
                    case NODE_REMOVE: {
                        TSStatus response = env.getConfigManager().getConsensusManager().write(new RemoveAINodePlan(this.removedAINode));
                        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new ProcedureException(String.format("Fail to remove [%s] AINode on Config Nodes [%s]", this.removedAINode, response.getMessage()));
                        }
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unknown state during executing removeAINodeProcedure, %s", new Object[]{state}));
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOGGER.error("Retrievable error trying to remove AINode [{}], state [{}]", new Object[]{this.removedAINode, state, e});
                if (this.getCycles() <= 5) break block21;
                this.setFailure(new ProcedureException(String.format("Fail to remove AINode [%s] at STATE [%s], %s", new Object[]{this.removedAINode, state, e.getMessage()})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, RemoveAINodeState removeAINodeState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected RemoveAINodeState getState(int stateId) {
        return RemoveAINodeState.values()[stateId];
    }

    @Override
    protected int getStateId(RemoveAINodeState removeAINodeState) {
        return removeAINodeState.ordinal();
    }

    @Override
    protected RemoveAINodeState getInitialState() {
        return RemoveAINodeState.MODEL_DELETE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REMOVE_AI_NODE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTAINodeLocation((TAINodeLocation)this.removedAINode, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.removedAINode = ThriftCommonsSerDeUtils.deserializeTAINodeLocation((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof RemoveAINodeProcedure) {
            RemoveAINodeProcedure thatProc = (RemoveAINodeProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.removedAINode.equals(this.removedAINode);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getProcId(), this.getState(), this.removedAINode});
    }
}

