/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.file.SystemPropertiesHandler;
import org.apache.iotdb.db.conf.DataNodeSystemPropertiesHandler;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.rescon.disk.DirectoryChecker;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.exception.encrypt.EncryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStartCheck {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBStartCheck.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    public static final String PROPERTIES_FILE_NAME = "system.properties";
    private static final String SCHEMA_DIR = config.getSchemaDir();
    private boolean isFirstStart = false;
    private Properties properties = new Properties();
    private final Map<String, Supplier<String>> systemProperties = new HashMap<String, Supplier<String>>();
    private final SystemPropertiesHandler systemPropertiesHandler;
    private static final String SYSTEM_PROPERTIES_STRING = "System properties:";
    private static final String DATA_REGION_NUM = "data_region_num";
    private static final String INTERNAL_ADDRESS = "dn_internal_address";
    private static final String INTERNAL_PORT = "dn_internal_port";
    private static final String RPC_ADDRESS = "dn_rpc_address";
    private static final String RPC_PORT = "dn_rpc_port";
    private static final String MPP_DATA_EXCHANGE_PORT = "dn_mpp_data_exchange_port";
    private static final String SCHEMA_REGION_CONSENSUS_PORT = "dn_schema_region_consensus_port";
    private static final String DATA_REGION_CONSENSUS_PORT = "dn_data_region_consensus_port";
    private static final String ENCRYPT_MAGIC_STRING = "encrypt_magic_string";
    private static final String magicString = "thisisusedfortsfileencrypt";
    private static final Map<String, Supplier<String>> variableParamValueTable = new HashMap<String, Supplier<String>>();
    private static final String IOTDB_VERSION_STRING = "iotdb_version";
    private static final String COMMIT_ID_STRING = "commit_id";
    private static final String DATA_NODE_ID = "data_node_id";
    private static final String CLUSTER_ID = "cluster_id";
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL = "schema_region_consensus_protocol";
    private static final String DATA_REGION_CONSENSUS_PROTOCOL = "data_region_consensus_protocol";
    private static final String VIRTUAL_STORAGE_GROUP_NUM = "virtual_storage_group_num";

    public static IoTDBStartCheck getInstance() {
        return IoTDBConfigCheckHolder.INSTANCE;
    }

    public static void reinitializeStatics() {
        IoTDBConfigCheckHolder.INSTANCE = new IoTDBStartCheck();
    }

    private String getVal(String paramName) {
        if (variableParamValueTable.containsKey(paramName)) {
            return variableParamValueTable.get(paramName).get();
        }
        return null;
    }

    private IoTDBStartCheck() {
        logger.info("Starting IoTDB {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        File dir = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error("Can not create schema dir: {}", (Object)SCHEMA_DIR);
                System.exit(-1);
            } else {
                logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
            }
        }
        this.systemPropertiesHandler = DataNodeSystemPropertiesHandler.getInstance();
        this.systemProperties.put(IOTDB_VERSION_STRING, () -> IoTDBConstant.VERSION);
        this.systemProperties.put(COMMIT_ID_STRING, () -> IoTDBConstant.BUILD_INFO);
        for (String param : variableParamValueTable.keySet()) {
            this.systemProperties.put(param, () -> this.getVal(param));
        }
    }

    public void checkDirectory() throws ConfigurationException, IOException {
        for (String dataDir : config.getLocalDataDirs()) {
            DirectoryChecker.getInstance().registerDirectory(new File(dataDir));
        }
        if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && DirectoryChecker.getInstance().isCrossDisk(config.getDataDirs())) {
            throw new ConfigurationException("Configuring the data directories as cross-disk directories is not supported under RatisConsensus(it will be supported in a later version).");
        }
        DirectoryChecker.getInstance().registerDirectory(new File(config.getSystemDir()));
        if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !config.getWalMode().equals((Object)WALMode.DISABLE)) {
            for (String walDir : commonConfig.getWalDirs()) {
                DirectoryChecker.getInstance().registerDirectory(new File(walDir));
            }
        }
        DirectoryChecker.getInstance().registerDirectory(new File(config.getConsensusDir()));
    }

    public static void checkOldSystemConfig() throws IOException {
        File oldPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME);
        if (oldPropertiesFile.exists()) {
            File correctPropertiesFile = SystemFileFactory.INSTANCE.getFile(config.getSystemDir() + File.separator + PROPERTIES_FILE_NAME);
            FileUtils.copyFile((File)oldPropertiesFile, (File)correctPropertiesFile);
            FileUtils.delete((File)oldPropertiesFile);
            logger.info("system.properties file has been moved successfully: {} -> {}", (Object)oldPropertiesFile.getAbsolutePath(), (Object)correctPropertiesFile.getAbsolutePath());
        }
    }

    public void checkSystemConfig() throws ConfigurationException, IOException {
        this.properties = this.systemPropertiesHandler.read();
        if (this.systemPropertiesHandler.isFirstStart()) {
            if ((config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") || config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensusV2") && config.getIotConsensusV2Mode().equals("stream")) && config.getWalMode().equals((Object)WALMode.DISABLE)) {
                throw new ConfigurationException("Configuring the WALMode as disable is not supported under IoTConsensus and IoTConsensusV2 stream mode");
            }
        } else {
            String versionString;
            if (!this.properties.containsKey(IOTDB_VERSION_STRING)) {
                logger.error("DO NOT UPGRADE IoTDB from v0.9 or lower version to v1.0! Please upgrade to v0.10 first");
                System.exit(-1);
            }
            if ((versionString = this.properties.getProperty(IOTDB_VERSION_STRING)).startsWith("0.")) {
                logger.error("IoTDB version is too old");
                System.exit(-1);
            }
            this.checkImmutableSystemProperties();
        }
    }

    private void upgradePropertiesFileFromBrokenFile() throws IOException {
        this.systemProperties.forEach((k, v) -> {
            if (!this.properties.containsKey(k)) {
                this.properties.setProperty((String)k, (String)v.get());
            }
        });
        this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
        this.properties.setProperty(COMMIT_ID_STRING, IoTDBConstant.BUILD_INFO);
        this.systemPropertiesHandler.overwrite(this.properties);
    }

    private void checkImmutableSystemProperties() throws IOException {
        for (Map.Entry<String, Supplier<String>> entry : this.systemProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.upgradePropertiesFileFromBrokenFile();
            logger.info("repair system.properties, lack {}", (Object)entry.getKey());
        }
        if (this.properties.containsKey(DATA_NODE_ID)) {
            config.setDataNodeId(Integer.parseInt(this.properties.getProperty(DATA_NODE_ID)));
        }
        if (this.properties.containsKey(CLUSTER_ID)) {
            config.setClusterId(this.properties.getProperty(CLUSTER_ID));
        }
        if (this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL)) {
            config.setSchemaRegionConsensusProtocolClass(this.properties.getProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL));
        }
        if (this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL)) {
            config.setDataRegionConsensusProtocolClass(this.properties.getProperty(DATA_REGION_CONSENSUS_PROTOCOL));
        }
    }

    private void throwException(String parameter, Object badValue) throws ConfigurationException {
        throw new ConfigurationException(parameter, String.valueOf(badValue), this.properties.getProperty(parameter), parameter + "can't be modified after first startup");
    }

    public void serializeDataNodeId(int dataNodeId) throws IOException {
        this.systemPropertiesHandler.put(new Object[]{DATA_NODE_ID, String.valueOf(dataNodeId)});
    }

    public void serializeClusterID(String clusterId) throws IOException {
        this.systemPropertiesHandler.put(new Object[]{CLUSTER_ID, clusterId});
    }

    public void serializeEncryptMagicString() throws IOException {
        String token;
        if (!(Objects.equals(TSFileDescriptor.getInstance().getConfig().getEncryptType(), "UNENCRYPTED") || Objects.equals(TSFileDescriptor.getInstance().getConfig().getEncryptType(), "org.apache.tsfile.encrypt.UNENCRYPTED") || (token = System.getenv("user_encrypt_token")) != null && !token.trim().isEmpty())) {
            throw new EncryptException("encryptType is not UNENCRYPTED, but user_encrypt_token is not set. Please set it in the environment variable.");
        }
        String encryptMagicString = EncryptUtils.byteArrayToHexString((byte[])TSFileDescriptor.getInstance().getConfig().getEncryptKey());
        this.systemProperties.put(ENCRYPT_MAGIC_STRING, () -> encryptMagicString);
        this.generateOrOverwriteSystemPropertiesFile();
    }

    public boolean checkConsensusProtocolExists(TConsensusGroupType type) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL);
        }
        if (type == TConsensusGroupType.SchemaRegion) {
            return this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL);
        }
        logger.error("Unexpected consensus group type");
        return false;
    }

    public void serializeMutableSystemPropertiesIfNecessary() throws IOException {
        long startTime = System.currentTimeMillis();
        boolean needsSerialize = false;
        for (String param : variableParamValueTable.keySet()) {
            if (this.properties.getProperty(param).equals(this.getVal(param))) continue;
            needsSerialize = true;
        }
        if (needsSerialize) {
            this.generateOrOverwriteSystemPropertiesFile();
        }
        long endTime = System.currentTimeMillis();
        logger.info("Serialize mutable system properties successfully, which takes {} ms.", (Object)(endTime - startTime));
    }

    public void generateOrOverwriteSystemPropertiesFile() throws IOException {
        this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v.get()));
        this.systemPropertiesHandler.overwrite(this.properties);
    }

    public void checkEncryptMagicString() throws IOException, ConfigurationException {
        this.properties = this.systemPropertiesHandler.read();
        String encryptMagicString = this.properties.getProperty(ENCRYPT_MAGIC_STRING);
        if (encryptMagicString != null) {
            byte[] magicBytes = EncryptUtils.hexStringToByteArray((String)encryptMagicString);
            TSFileDescriptor.getInstance().getConfig().setEncryptKey(magicBytes);
        }
    }

    static {
        variableParamValueTable.put(INTERNAL_ADDRESS, () -> String.valueOf(config.getInternalAddress()));
        variableParamValueTable.put(INTERNAL_PORT, () -> String.valueOf(config.getInternalPort()));
        variableParamValueTable.put(RPC_ADDRESS, () -> String.valueOf(config.getRpcAddress()));
        variableParamValueTable.put(RPC_PORT, () -> String.valueOf(config.getRpcPort()));
        variableParamValueTable.put(MPP_DATA_EXCHANGE_PORT, () -> String.valueOf(config.getMppDataExchangePort()));
        variableParamValueTable.put(SCHEMA_REGION_CONSENSUS_PORT, () -> String.valueOf(config.getSchemaRegionConsensusPort()));
        variableParamValueTable.put(DATA_REGION_CONSENSUS_PORT, () -> String.valueOf(config.getDataRegionConsensusPort()));
    }

    private static class IoTDBConfigCheckHolder {
        private static IoTDBStartCheck INSTANCE = new IoTDBStartCheck();

        private IoTDBConfigCheckHolder() {
        }
    }
}

